#!BPY
# -*- coding: cp1252 -*-

# Dies ist ein Skript fr Blender um leichter Daten aus KETSIM auf Blender zu bertragen.
# Zum Ausfhren wird eine Installation von Python und PyOpenGl bentigt.


import Blender                                              ## Import der Grundfunktionen von Blender
import os                                                   
import sys
import math
import string
import binascii

from Blender import NMesh                                   ## Import fuer Meshfunktion in Blender
from Blender import Ipo, Object, Material
from Blender.Draw import *
from Blender.BGL import *
from Blender import *

from OpenGL.GL import *                                     ## Import fuer OpenGL Funktionen
from OpenGL.GLU import *
from Blender import Window

##------------------------------------------------------------- GLOBALE EINSTELLUNGEN --------------------------------------------------

counter1 = 0                                                ## Initialisierung vom globalen Variablen
varray = []
tess_ID = 0
punkte =[]
p1 = 0
p2 = 0
p3 = 0
p4 = 0
p5 = 0
p6 = 0

pi = 3.141592654

faktor = 200       ## gesamter zustzlicher Vergroesserungsfaktor
scaletime = 1500    ## Zeitfaktor, der die Dauer der Animation streckt
diskret = 0.9       ## diskretisierungsfaktor, um Winkelanomolien, die durch den Zeitfaktor in Blender entstehen zu kompensieren



##------------------------------------------------------------- FUNKTIONEN -------------------------------------------------------------

## In dieser Funktion werden aus .obj Dateien, Meshes in Blender

def OBJIMPORT(pfad):
    global objdaten
    f = open(pfad, 'r')
    ganzesfile = [map(lesen, line.split()) for line in f if line.strip()]
    objdaten = []
    
    for s in ganzesfile:
        if "#" in s:
            nix = 0
        else:
            objdaten.append(s)

    f.close()

    temp = []
    vertices_array = []
    texcood_array = []
    vertnorm_array = []
    faces_array = []
    facestemp_array = []
    restinfo_array = []
    material = []
    materiallib = []
    zaehler = 0
    meshname = "notdef"

    for i in range(len(objdaten)):
        temp = []
        if objdaten[i][0] == "g":
            meshname = objdaten[i][1]
        elif objdaten[i][0] == "v":
            y = len(objdaten[i])
            for j in range(1,y):
                temp.append(objdaten[i][j]*faktor*tempdaten[5][0])
            vertices_array.append(temp)
        elif objdaten[i][0] == "vt":
            y = len(objdaten[i])
            for j in range(1,y):
                temp.append(objdaten[i][j])
            texcood_array.append(temp)
        elif objdaten[i][0] == "vn":
            y = len(objdaten[i])
            for j in range(1,y):
                temp.append(objdaten[i][j])
            vertnorm_array.append(temp)
        elif objdaten[i][0] == "f":
            y = len(objdaten[i])
            for j in range(1,y):
                temp.append(objdaten[i][j])
            facestemp_array.append(temp)
            
        elif objdaten[i][0] == "usemtl":
            temp.append(objdaten[i][1])
            material.append(temp)
            if zaehler == 0:
                zaehler = 1
            else:
                faces_array.append(facestemp_array)
                facestemp_array = []
                
        elif objdaten[i][0] == "mtllib":
            temp.append(objdaten[i][1])
            materiallib.append(temp)
        
        else:
            nix = 0

    faces_array.append(facestemp_array)
    
    print "vertices ", len(vertices_array)
    print "texcood ", len(texcood_array)
    print "vertnorm ", len(vertnorm_array)
    print "faces ", len(faces_array), len(faces_array[0]), len(faces_array[1])
    print "mtllib ", materiallib
    print "usemtl ", material
    print meshname

    fall = 0
    point1 = ""
    point2 = ""
    point3 = ""
    point4 = ""
    int1_1 = 0
    int1_2 = 0
    int1_3 = 0
    int2_1 = 0
    int2_2 = 0
    int2_3 = 0
    int3_1 = 0
    int3_2 = 0
    int3_3 = 0
    int4_1 = 0
    int4_2 = 0
    int4_3 = 0


    for i in range(len(vertices_array)):
        v = NMesh.Vert(vertices_array[i][0],vertices_array[i][1],vertices_array[i][2])
        me.verts.append(v)

    for i in range(len(faces_array)):
        for j in range(len(faces_array[i])):
            form = len(faces_array[i][j])
            point1 = str(faces_array[i][j][0])
            point2 = str(faces_array[i][j][1])
            point3 = str(faces_array[i][j][2])

            if form == 4:
                point4 = str(faces_array[i][j][3])
            else:
                nix = 0
            
            try:
                int1_1, int1_2, int1_3 = map(int, point1.split("//"))
                int2_1, int2_2, int2_3 = map(int, point2.split("//"))
                int3_1, int3_2, int3_3 = map(int, point3.split("//"))
                if form == 4:
                    int4_1, int4_2, int4_3 = map(int, point4.split("//"))
                else:
                    nix = 0

                fall = 3

            except:
                int1_1, int1_2 = map(int, point1.split("//"))
                int2_1, int2_2 = map(int, point2.split("//"))
                int3_1, int3_2 = map(int, point3.split("//"))
                if form == 4:
                    int4_1, int4_2 = map(int, point4.split("//"))
                else:
                    nix = 0
                    
                fall = 2
                
            if form == 4:            
                f = NMesh.Face()
                f.v.append(me.verts[int1_1-1])
                f.v.append(me.verts[int2_1-1])
                f.v.append(me.verts[int3_1-1])
                f.v.append(me.verts[int4_1-1])
                me.faces.append(f)
            else:
                f = NMesh.Face()
                f.v.append(me.verts[int1_1-1])
                f.v.append(me.verts[int2_1-1])
                f.v.append(me.verts[int3_1-1])
                me.faces.append(f)

#########################################################################################################################

    ## Definition der 3 Callbackroutinen fr OpenGl
    ## Die folgenden Funktionen werden fr die Tesselierung und der Mesherstellung in Blender bentigt

def myBegin(eingabe_daten):                                 # myBegin erhaelt Information ueber Erstellungsweise der Polygone
    global tess_ID,varray
    tess_ID = eingabe_daten
    varray = []


def myVertex(vertex_data):                                  # Punkte werden in ein Arrray geschrieben mit Namen varray
    global varray
    varray.append(vertex_data)

    
def myEnd():                                                # Zuweisung der Tesselierungs-Art
    global varray,tess_ID,fehler_tess
    if tess_ID == 4:
        GL_TRIANGLES()
    elif tess_ID == 5:
        GL_TRIANGLES_STRIP()
    elif tess_ID == 6:                                        
        GL_TRIANGLE_FAN()
    else:
        fehler_tess = fehler_tess+1


    ## Definitionen der 3 OpenGl-Anweisungen

def GL_TRIANGLES():
    global varray,me,counter1
    N = len(varray)/3
    v = []
    for i in range(len(varray)):
        v = NMesh.Vert(varray[i][0],varray[i][1],varray[i][2])
        me.verts.append(v)
    for i in range(N):
        f = NMesh.Face()
        f.v.append(me.verts[counter1 + 3*i])
        f.v.append(me.verts[counter1 + 3*i+1])
        f.v.append(me.verts[counter1 + 3*i+2])
        me.faces.append(f)
    counter1 = counter1 + len(varray)


def GL_TRIANGLES_STRIP():
    global varray,me,counter1
    N = len(varray) - 2
    v = []
    for i in range(len(varray)):
        v = NMesh.Vert(varray[i][0],varray[i][1],varray[i][2])
        me.verts.append(v)
    for i in range(N):
        f = NMesh.Face()
        if len(varray)%2 == 0:
            f.v.append(me.verts[counter1 + i + 1])
            f.v.append(me.verts[counter1 + i])
            f.v.append(me.verts[counter1 + i + 2])
        else:        
            f.v.append(me.verts[counter1 + i])
            f.v.append(me.verts[counter1 + i + 1])
            f.v.append(me.verts[counter1 + i + 2])
        me.faces.append(f)
    counter1 = counter1 + len(varray)
                

def GL_TRIANGLE_FAN():
    global varray,me,counter1
    N = len(varray) - 2
    v = []
    for i in range(len(varray)):
        v = NMesh.Vert(varray[i][0],varray[i][1],varray[i][2])     
        me.verts.append(v)
    for i in range(N):
        f = NMesh.Face()
        f.v.append(me.verts[counter1 + 0])
        f.v.append(me.verts[counter1 + i+1])
        f.v.append(me.verts[counter1 + i+2])
        me.faces.append(f)
    counter1 = counter1 + len(varray)


    ## Funktionsalghorithmus zur Erstellung von den Seiten der jeweilgen Teile; counter1 wurde deswegen eingefhrt (extrem wichtig)
    ## counter1 entspricht der Position des letzten Punktes, der dem Mesh zugefgt wurde. Erhaelt die Hoehe der Seite relativ
    ## zur letzten tesselierten Oberflaeche.

def seite(verschiebung):
    global punkte,counter1
    N = 2*len(punkte) - 2
    for i in range(len(punkte)):
        v = NMesh.Vert(punkte[i][0],punkte[i][1],punkte[i][2])
        me.verts.append(v)
        v = NMesh.Vert(punkte[i][0],punkte[i][1],punkte[i][2]+verschiebung)
        me.verts.append(v)
    for i in range(N):
        f = NMesh.Face()
        f.v.append(me.verts[counter1 + i])
        f.v.append(me.verts[counter1 + i + 1])
        f.v.append(me.verts[counter1 + i + 2])
        me.faces.append(f)
    f = NMesh.Face()
    f.v.append(me.verts[counter1 + i+1])
    f.v.append(me.verts[counter1 + i+2])
    f.v.append(me.verts[counter1 + 0])
    me.faces.append(f)
    f = NMesh.Face()
    f.v.append(me.verts[counter1 + i+2])
    f.v.append(me.verts[counter1 + 0])
    f.v.append(me.verts[counter1 + 1])
    me.faces.append(f)    
    counter1 = counter1 + len(punkte)*2


    ## Funktion um Zylinder-Punkte zu erhalten (Genauigkeit 10 Grad)
    ## Erstellt Kreispunkte mit Radius r, x-Verschiebung offsetx, y-Verschiebung offsety und z-Verschiebung offsetz.

def zylinder_punkte(r,offsetx,offsety,offsetz):
    global punkte, pi
    punkte = []
    for i in range(36):                                         
        neuer_punkt = [offsetx + math.cos(i*10 * pi/180) * r, offsety + math.sin(i*10 * pi/180) * r, offsetz]
        punkte.append(neuer_punkt)
    

    ## Funktion zum Dateioeffnen bei KETSIM-Teilen abhaengig vom Teil

def openfile(eigenschaft):
    global punkte, p1, p2, p3, p4, p5, p6, pfad, faktor
    f = open(pfad, 'r')
    typ = f.readline()
    anzahl = int(f.readline())
    cache = f.readline()
    p = f.readline()
    p1 = float(p)*faktor
    if eigenschaft == "VZ" or eigenschaft == "FS" or eigenschaft == "SS":
        nix = 0
    else:
        p = f.readline()
        p2 = float(p)*faktor
        p = f.readline()
        p3 = float(p)*faktor
        p = f.readline()
        p4 = float(p)*faktor
    if eigenschaft == "RK_HK_NN" or eigenschaft == "AG_FL1" or eigenschaft == "AG_FL2":
        p = f.readline()
        p5 = float(p)*faktor
        p = f.readline()
        p6 = float(p)*faktor
    if eigenschaft == "AG_FL1" or eigenschaft == "AG_FL2":
        nix = 1
    else:
        punkte = [map(float, line.split()) for line in f if line.strip()]
        for i in range(len(punkte)):                        
            for j in range(3):
                punkte[i][j] = punkte[i][j] * faktor
    f.close()


    ## bergabe der Punkte aus den Dateien an OpenGL
    ## Beginn der Benutzung von PyOpenGl

def tesselation(eigenschaft):
    global tess, punkte
    gluTessBeginPolygon(tess,0)                                 
    gluTessBeginContour(tess)                                   
    for i in range(len(punkte)):
        gluTessVertex(tess, punkte[i], punkte[i])               
    gluTessEndContour(tess)
    if eigenschaft == "zk_zl_oben" or eigenschaft == "zk_zl_unten":
	gluTessBeginContour(tess)
        if eigenschaft == "zk_zl_oben":
            offsetz = 0
        else:
            offsetz = p4*-1	
	zylinder_punkte(p2/2,p1/2*-1,p3,offsetz)
	for i in range(len(punkte)):
            gluTessVertex(tess, punkte[i],punkte[i])		
        gluTessEndContour(tess)
        gluTessBeginContour(tess)
        zylinder_punkte(p2/2,p1/2,p3,offsetz)
        for i in range(len(punkte)):
            gluTessVertex(tess, punkte[i],punkte[i])
        gluTessEndContour(tess)
    else:
        nix = 0
    gluTessEndPolygon(tess)


    ## Funktionen der einzelnen Teile. Jedes Teil ist eine Aneinanderreihung von Oberflaechen und Seitenfunktionen, wobei
    ## counter1 die Gesamtpunkte und gleichzeitig die Position mitzaehlt


def KETSIM_RK_HK_BB():
    global tess,punkte,p3,p4
    openfile("RK_HK_BB")
    tess = gluNewTess()                                         # Neues Tess-Objekt
    gluTessCallback(tess , GLU_TESS_BEGIN, myBegin)             # Callback-Routinen
    gluTessCallback(tess , GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess , GLU_TESS_END, myEnd)
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = punkte[i][2] - p3
    tesselation("normal")                                       # Oberseite
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = punkte[i][2] - p4
    tesselation("normal")                                       # Unterseite
    seite(p4)                                                   # Seite
    zylinder_punkte(p2,0,0,0)                                   # Kreispunkte
    tesselation("normal")                                       # Zylinderoberseite
    seite(p3*-1)                                                # Zylinderseite


def KETSIM_RK_HK_NN():
    global tess, punkte, p3, p4, p5, p6
    openfile("RK_HK_NN")
    tess = gluNewTess()                                         # Neues Tess-Objekt
    gluTessCallback(tess , GLU_TESS_BEGIN, myBegin)             # Callback-Routinen
    gluTessCallback(tess , GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess , GLU_TESS_END, myEnd)
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = punkte[i][2] - p3
    tesselation("normal")                                       # Oberseite
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = punkte[i][2] - p4
    tesselation("normal")                                       # Unterseite
    seite(p4)                                                   # Seite
    zylinder_punkte(p2,0,0,0)
    tesselation("normal")
    seite(p3*-1)
    offset = (p3+p4+p5)*-1
    zylinder_punkte(p6,0,0,offset)
    tesselation("normal")
    seite(p5)
    zylinder_punkte(p6,p1,0,offset)
    tesselation("normal")
    seite(p5)


def KETSIM_VZ():
    global tess, punkte, p1
    openfile("VZ")
    tess = gluNewTess()                                         # Neues Tess-Objekt
    gluTessCallback(tess , GLU_TESS_BEGIN, myBegin)             # Callback-Routinen
    gluTessCallback(tess , GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess , GLU_TESS_END, myEnd)
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = 0
    tesselation("normal")                                       # Oberseite
    for i in range(len(punkte)):                                # z-Verschiebung
        punkte[i][2] = 0 - p1
    tesselation("normal")                                       # Unterseite
    seite(p1)                                                   # Seite
        

def KETSIM_ZK_ZL():
    global tess, punkte, p1, p2, p3, p4
    openfile("ZK_ZL")
    tess = gluNewTess()
    gluTessCallback(tess, GLU_TESS_BEGIN, myBegin)
    gluTessCallback(tess, GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess, GLU_TESS_END, myEnd)
    for i in range(len(punkte)):
        punkte[i][2] = 0
    tesselation("zk_zl_oben")
    openfile("ZK_ZL")
    for i in range(len(punkte)):
        punkte[i][2] = 0 - p4
    tesselation("zk_zl_unten")
    openfile("ZK_ZL")
    for i in range(len(punkte)):
        punkte[i][2] = 0
    seite(p4*-1)
    zylinder_punkte(p2/2,p1/2*-1,p3,0)
    seite(p4*-1)
    zylinder_punkte(p2/2,p1/2,p3,0)
    seite(p4*-1)


def KETSIM_AG_FL1():
    global tess, punkte, p1, p2, p3, p4, p5, p6
    openfile("AG_FL1")
    tess = gluNewTess()
    gluTessCallback(tess, GLU_TESS_BEGIN, myBegin)
    gluTessCallback(tess, GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess, GLU_TESS_END, myEnd)
    zylinder_punkte(p2/2,0,0,p4*-1)
    del punkte[0:9]
    del punkte[19:27]
    eckpunkt = [p3, p2/2*-1, p4*-1]
    punkte.append(eckpunkt)
    eckpunkt = [p3, p2/2   , p4*-1]
    punkte.append(eckpunkt)
    tesselation("normal")
    for i in range(len(punkte)):
        punkte[i][2] = (p4 + p5) *-1
    tesselation("normal")
    seite(p5)
    zylinder_punkte(p1,0,0,0)
    tesselation("normal")
    seite(p4*-1)
    zylinder_punkte(p1,0,0,(p4+p5+p6)*-1)
    tesselation("normal")
    seite(p6)

def KETSIM_AG_FL2():
    global tess, punkte, p1, p2, p3, p4, p5, p6
    openfile("AG_FL2")
    tess = gluNewTess()
    gluTessCallback(tess, GLU_TESS_BEGIN, myBegin)
    gluTessCallback(tess, GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess, GLU_TESS_END, myEnd)
    punkte = []
    for i in range(27,36):                                         
        neuer_punkt = [math.cos(i*10 * pi/180) * p2/2,math.sin(i*10 * pi/180) * p2/2, p4*-1]
        punkte.append(neuer_punkt)
    for i in range(10):
        neuer_punkt = [math.cos(i*10 * pi/180) * p2/2,math.sin(i*10 * pi/180) * p2/2, p4*-1]
        punkte.append(neuer_punkt)
    eckpunkt = [p3*-1,p2/2, p4*-1]
    punkte.append(eckpunkt)
    eckpunkt = [p3*-1,p2/2*-1, p4*-1] 
    punkte.append(eckpunkt)
    tesselation("normal")
    for i in range(len(punkte)):
        punkte[i][2] = (p4 + p5) *-1
    tesselation("normal")
    seite(p5)
    zylinder_punkte(p1,0,0,0)
    tesselation("normal")
    seite(p4*-1)
    zylinder_punkte(p1,0,0,(p4+p5+p6)*-1)
    tesselation("normal")
    seite(p6)

##--------------------------------------------- Funktionen fr IPO (Farbe, Pos, Angle) --------------------------------------------------

def minmax():
    global minmaxfiles, ordner, FE_min, FE_max, RK_min, RK_max, ZKFL_min, ZKFL_max, ZKZL_min, ZKZL_max, VZ_min, VZ_max
    global delta_FE, delta_RK, delta_ZKFL, delta_ZKZL, delta_VZ
    
    for s in minmaxfiles:
        minmax_pfad = ordner + "/" + str(s)
        f = open(minmax_pfad)
        if "FE" in s:
            FE_min = int(f.readline())
            FE_max = int(f.readline())
            delta_FE = math.fabs(FE_min - FE_max)
        elif "RK" in s:
            RK_min = int(f.readline())
            RK_max = int(f.readline())
            delta_RK = math.fabs(RK_min - RK_max)
        elif "ZKFL" in s:
            ZKFL_min = int(f.readline())
            ZKFL_max = int(f.readline())
            delta_ZKFL = math.fabs(ZKFL_min - ZKFL_max)
        elif "ZKZL" in s:
            ZKZL_min = int(f.readline())
            ZKZL_max = int(f.readline())
            delta_ZKZL = math.fabs(ZKZL_min - ZKZL_max)
        elif "VZ" in s:
            VZ_min = int(f.readline())
            VZ_max = int(f.readline())
            delta_VZ = math.fabs(VZ_min - VZ_max)
        else:
            print "unbekannte Minmax-Datei"
        f.close()

def FarbSet(bodyname, nummer_teil,objektname, input_min, input_delta, eigenschaft):
    global me, scaletime
    pfad2 = ordner + "/" + str(bodyname) + "." + str(string.zfill(nummer_teil, 4)) + endung
    mat = Material.New(name)
    prozent = 0
    if os.path.exists(pfad2) == 1:
        
        curvedatei = open(pfad2, 'r')

        curvedaten = [map(float, line.split()) for line in curvedatei if line.strip()]
        curvedatei.close()

        ipo = Ipo.New('Material','ObIpo')
        curveG = ipo.addCurve('G')
        curveR = ipo.addCurve('R')
        curveB = ipo.addCurve('B')
        curveG.setInterpolation('Bezier')
        curveR.setInterpolation('Bezier')
        curveB.setInterpolation('Bezier')
        
        for i in range(len(curvedaten)):
            if eigenschaft == "primitive":
                prozent = curvedaten[i][5]
            else:    
                input_data = curvedaten[i][5] - input_min
                prozent = input_data/input_delta
                
            if 0 <= prozent < 0.25:
                curveB.addBezier((curvedaten[i][0]*scaletime, 1))
                curveG.addBezier((curvedaten[i][0]*scaletime, prozent/0.25))
                curveR.addBezier((curvedaten[i][0]*scaletime, 0))
            elif 0.25 <= prozent < 0.5:
                curveB.addBezier((curvedaten[i][0]*scaletime, 1 - (prozent-0.25)/0.25))
                curveG.addBezier((curvedaten[i][0]*scaletime, 1))
                curveR.addBezier((curvedaten[i][0]*scaletime, 0))
            elif 0.5 <= prozent < 0.75:
                curveB.addBezier((curvedaten[i][0]*scaletime, 0))
                curveG.addBezier((curvedaten[i][0]*scaletime, 1))
                curveR.addBezier((curvedaten[i][0]*scaletime, (prozent-0.5)/0.25))
            elif 0.75 <= prozent:
                curveB.addBezier((curvedaten[i][0]*scaletime, 0))
                curveG.addBezier((curvedaten[i][0]*scaletime, 1-(prozent-0.75)/0.25))
                curveR.addBezier((curvedaten[i][0]*scaletime, 1))
            else:
                nix = 0
        curveG.update()
        curveR.update()
        curveB.update()
        ob = Material.Get(name)
        ob.setIpo(ipo)
        me.materials.append(mat)
        
    else:
        nix = 0

## Diese Funktion setzt die Positionsdaten
       
def IpoCurveSet(bodyname,nummer_teil,objektname):
    global faktor, endung, ipo_fehler, daten, scaletime
    pi = 3.141592654
    pfad2 = ordner + "/" + str(bodyname) + "." + str(string.zfill(nummer_teil, 4)) + endung

    x_rel = 0
    y_rel = 0
    z_rel = 0
    a_rel = 0
    b_rel = 0
    g_rel = 0
    a = 0
    b = 0
    g = 0
    
    if os.path.exists(pfad2) == 1: 
        curvedatei = open(pfad2, 'r')                                                   # Oeffnen und Auslesen der Datei in Array

        curvedaten = [map(float, line.split()) for line in curvedatei if line.strip()]
        curvedatei.close()
        for i in range(len(curvedaten)):                                                # Skalierung der Datein um Faktor faktor
                for j in range(len(curvedaten[i])-1):
                    curvedaten[i][j] = curvedaten[i][j] * faktor
        ipo = Ipo.New('Object', 'ObIpo')            # Neues Ipo-Objekt
        x = ipo.addCurve('LocX')                    # Initialisieren der zu uebernehmenden Daten
        y = ipo.addCurve('LocY')
        z = ipo.addCurve('LocZ')
        if objektname == "primitive" or objektname == "obj":
            alpha = ipo.addCurve('RotX')
            beta = ipo.addCurve('RotY')
        gamma = ipo.addCurve('RotZ')
        x.setInterpolation('Bezier')
        y.setInterpolation('Bezier')
        z.setInterpolation('Bezier')
        if objektname == "primitive" or objektname == "obj":
            alpha.setInterpolation('Bezier')
            beta.setInterpolation('Bezier')
        gamma.setInterpolation('Bezier')

        a_nachher = 0
        b_nachher = 0
        g_nachher = 0
        a_vorher = 0
        b_vorher = 0
        g_vorher = 0
        umdrehung_a = 0
        umdrehung_b = 0
        umdrehung_g = 0
        
        for i in range(len(curvedaten)):            # Uebertragung der Daten zum jeweilgen Zeitpunkt (Winkel werden rckskaliert)
                
            if objektname == "primitive" or objektname == "obj":


                position = WINKEL(curvedaten[i][4]/faktor,curvedaten[i][5]/faktor,curvedaten[i][6]/faktor,tempdaten[4][0],tempdaten[4][1],tempdaten[4][2],tempdaten[3][0],tempdaten[3][1],tempdaten[3][2])
        
                x.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][1] + position[0]*tempdaten[5][0]*faktor))
                y.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][2] + position[1]*tempdaten[5][0]*faktor))
                z.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][3] + position[2]*tempdaten[5][0]*faktor))

                a_nachher = position[3]/10*180/pi
                b_nachher = position[4]/10*180/pi
                g_nachher = position[5]/10*180/pi

                if diskret*36.0 < a_nachher-a_vorher <= 36.0:
                    umdrehung_a = umdrehung_a - 36.0
                elif -1.0*diskret*36.0 > a_nachher-a_vorher >= -36.0:
                    umdrehung_a = umdrehung_a + 36.0
                else:
                    nix = 0

                if diskret*36.0 < b_nachher-b_vorher <= 36.0:
                    umdrehung_b = umdrehung_b - 36.0
                elif -1.0*diskret*36.0 > b_nachher-b_vorher >= -36.0:
                    umdrehung_b = umdrehung_b + 36.0
                else:
                    nix = 0

                if diskret*36.0 < g_nachher-g_vorher <= 36.0:
                    umdrehung_g = umdrehung_g - 36.0
                elif -1.0*diskret*36.0 > g_nachher-g_vorher >= -36.0:
                    umdrehung_g = umdrehung_g + 36.0
                else:
                    nix = 0
    
                alpha.addBezier((curvedaten[i][0]*scaletime/faktor,(position[3]/10*180/pi + umdrehung_a)))
                beta.addBezier((curvedaten[i][0]*scaletime/faktor,(position[4]/10*180/pi + umdrehung_b)))
                gamma.addBezier((curvedaten[i][0]*scaletime/faktor,(position[5]/10*180/pi + umdrehung_g)))
                
                a_vorher = position[3]/10*180/pi
                b_vorher = position[4]/10*180/pi
                g_vorher = position[5]/10*180/pi
               
            else:
                x.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][1]))
                y.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][2]))
                z.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][3]))
                gamma.addBezier((curvedaten[i][0]*scaletime/faktor,curvedaten[i][4]/faktor/10*180/pi))
                
        x.update()
        y.update()
        z.update()                                  # Update und Setzen der Werte in Blender
        if objektname == "primitive":
            alpha.update()
            beta.update()
        gamma.update()
        ob = Object.Get(name)
        ob.setIpo(ipo)
    else:
        ipo_fehler = ipo_fehler + 1

## Die Funktionen WINKEL und MATRIX erzeugen die Umrechnung von Kardanwinkel in Eulerwinkel

def WINKEL(a_pos,b_pos,g_pos,a_body,b_body,c_body,x_body, y_body, z_body):
    global A_wr, A_rl
    ergebnis = []
    zeile = []
    vektor = []
    A_wr = MATRIX(a_pos,b_pos,g_pos)
    A_rl = MATRIX(a_body,b_body,c_body)
    A_wl = []

    ## Ortsvektor

    for k in range(3):
        temp = A_wr[k][0]*x_body + A_wr[k][1]*y_body + A_wr[k][2]*z_body
        ergebnis.append(temp)

    ## Rotation

    for j in range(3):
        for i in range(3):
            temp = A_wr[j][0]*A_rl[0][i] + A_wr[j][1]*A_rl[1][i] + A_wr[j][2]*A_rl[2][i]
            zeile.append(temp)
        A_wl.append(zeile)
        zeile = []


    roty = math.asin(-1 * A_wl[2][0])
    nenner = math.cos(roty)


    if nenner > 10**-10:
        rotx = math.atan2( A_wl[2][1] , A_wl[2][2] )
        rotz = math.atan2( A_wl[1][0] , A_wl[0][0] )
    else:
        rotx = 0
        rotz = math.atan2( A_wl[1][2] , A_wl[1][1] )
        print "singularitt"

    ergebnis.append(rotx)
    ergebnis.append(roty)
    ergebnis.append(rotz)
    
    return ergebnis

    

def MATRIX(a,b,g):
    A = []
    A_00 = math.cos(b)*math.cos(g)
    A_10 = math.sin(a)*math.sin(b)*math.cos(g) + math.cos(a)*math.sin(g)
    A_20 = -1 * math.cos(a)*math.sin(b)*math.cos(g) + math.sin(a)*math.sin(g)
    A_01 = -1 * math.cos(b)*math.sin(g)
    A_11 = -1 * math.sin(g)*math.sin(b)*math.sin(a) + math.cos(a)*math.cos(g)
    A_21 = math.cos(a)*math.sin(b)*math.sin(g) + math.sin(a)*math.cos(g)
    A_02 = math.sin(b)
    A_12 = -1 * math.sin(a)*math.cos(b)
    A_22 = math.cos(a)*math.cos(b)
    temp = [A_00,A_01,A_02]
    A.append(temp)
    temp = [A_10,A_11,A_12]
    A.append(temp)
    temp = [A_20,A_21,A_22]
    A.append(temp)
    return A



    
    


##------------------------------------------------------------- Primitivkrper ----------------------------------------------------------        

def CUBE(eigenschaft):
    global daten, faktor
    openfile_primitives()
    if eigenschaft == "cube":        
        k_x = float(daten[6][0]*faktor*daten[5][0])/2                  ## Wrfelkanten
        k_y = k_x
        k_z = k_x
    else:
        k_x = float(daten[6][0]*faktor*daten[5][0])/2                  ## Cuboidkanten
        k_y = float(daten[7][0]*faktor*daten[5][0])/2
        k_z = float(daten[8][0]*faktor*daten[5][0])/2        
    if eigenschaft == "cube":
        primitive_punkte = []
        punkt = [k_x,k_y,-1*k_z]                    ## Cube-Punkte
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,k_y, -1*k_z]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,-1*k_y,-1*k_z]
        primitive_punkte.append(punkt)
        punkt = [k_x,-1*k_y,-1*k_z]
        primitive_punkte.append(punkt)
        punkt = [k_x,k_y,k_z]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,k_y, k_z]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,-1*k_y,k_z]
        primitive_punkte.append(punkt)
        punkt = [k_x,-1*k_y,k_z]
        primitive_punkte.append(punkt)
    else:
        primitive_punkte = []
        punkt = [k_x,k_y,0]                         ## Cuboid-Punkte
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,k_y,0]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,-1*k_y,0]
        primitive_punkte.append(punkt)
        punkt = [k_x,-1*k_y,0]
        primitive_punkte.append(punkt)
        punkt = [k_x,k_y,-2*k_z]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,k_y, -2*k_z]
        primitive_punkte.append(punkt)
        punkt = [-1*k_x,-1*k_y,-2*k_z]
        primitive_punkte.append(punkt)
        punkt = [k_x,-1*k_y,-2*k_z]
        primitive_punkte.append(punkt)    
    for i in range(len(primitive_punkte)):
        v = NMesh.Vert(primitive_punkte[i][0],primitive_punkte[i][1],primitive_punkte[i][2])
        me.verts.append(v)
    for i in range(2):
        f = NMesh.Face()
        f.v.append(me.verts[0 + i*4])
        f.v.append(me.verts[1 + i*4])
        f.v.append(me.verts[2 + i*4])
        f.v.append(me.verts[3 + i*4])
        me.faces.append(f)
    for i in range(3):
        f = NMesh.Face()
        f.v.append(me.verts[0 + i])
        f.v.append(me.verts[1 + i])
        f.v.append(me.verts[5 + i])
        f.v.append(me.verts[4 + i])
        me.faces.append(f)
    f = NMesh.Face()
    f.v.append(me.verts[0])
    f.v.append(me.verts[3])
    f.v.append(me.verts[7])
    f.v.append(me.verts[4])
    me.faces.append(f)

def CYLINDER():
    global daten, tess, punkte, counter1, faktor
    openfile_primitives()
    tess = gluNewTess()
    gluTessCallback(tess, GLU_TESS_BEGIN, myBegin)
    gluTessCallback(tess, GLU_TESS_VERTEX, myVertex)
    gluTessCallback(tess, GLU_TESS_END, myEnd)
    zylinder_punkte(daten[7][0]*daten[5][0]*faktor,0,0,0)
    tesselation("normal")
    zylinder_punkte(daten[6][0]*daten[5][0]*faktor,0,0,-1* daten[8][0]*daten[5][0]*faktor)    ###
    tesselation("normal")

    for i in range(36):
        r = daten[7][0]*daten[5][0]*faktor
        neuer_punkt = [math.cos(i*10 * pi/180) * r, math.sin(i*10 * pi/180) * r, 0]
        v = NMesh.Vert(neuer_punkt[0],neuer_punkt[1],neuer_punkt[2]) 
        me.verts.append(v)        
        r = daten[6][0]*daten[5][0]*faktor
        neuer_punkt = [math.cos(i*10 * pi/180) * r, math.sin(i*10 * pi/180) * r, -1*daten[8][0]*daten[5][0]*faktor]  ###
        v = NMesh.Vert(neuer_punkt[0],neuer_punkt[1],neuer_punkt[2])
        me.verts.append(v)
    for i in range(70):
        print i
        f = NMesh.Face()
        f.v.append(me.verts[counter1 + i])
        f.v.append(me.verts[counter1 + i + 1])
        f.v.append(me.verts[counter1 + i + 2])
        me.faces.append(f)
    f = NMesh.Face()
    f.v.append(me.verts[counter1 + i+1])
    f.v.append(me.verts[counter1 + i+2])
    f.v.append(me.verts[counter1 + 0])
    me.faces.append(f)
    f = NMesh.Face()
    f.v.append(me.verts[counter1 + i+2])
    f.v.append(me.verts[counter1 + 0])
    f.v.append(me.verts[counter1 + 1])
    me.faces.append(f)    
    
            
def openfile_primitives():
    global daten
    f = open(pfad, 'r')
    ganzesfile = [map(lesen, line.split()) for line in f if line.strip()]

    daten = ganzesfile
    delete = []

    for n in range(len(ganzesfile)):
        inworten = str(ganzesfile[n][0])
        if str(ganzesfile[n][0])[0] == "#":
            delete.append(n)
        else:
            nix = 0

    for k in range(len(delete)):
        del daten[delete[-k-1]]

def lesen(wert):
    try:
        x = float(wert)
    except ValueError: 
        x = str(wert)

    return x
    
    
##------------------------------------------------------------- HAUPTPROGRAMM ----------------------------------------------------------

teil_rk_hk_bb = 0           ## Initialisieren von bentigten globalen Variablen
teil_rk_hk_nn = 0
teil_vz = 0
teil_zk_zl = 0
teil_ag_fl1 = 0
teil_ag_fl2 = 0
teil_cube = 0
teil_cuboid = 0
teil_sphere = 0
teil_cylinder = 0
teil_obj = 0
fehler_teil = 0
fehler_tess = 0
ipo_fehler = 0

rk_hk_bb_type = 0
rk_hk_nn_type = 0
vz_fs_ss_type = 0

status_teil_bb = 0
status_teil_nn = 0
status_teil_vz = 0
status_teil_fl1 = 0
status_teil_fl2 = 0
status_teil_zl = 0

ordner = "nix"
pfad = "nix"
name = "nix"

minmaxfiles = []
objdaten = []
tempdaten = []
FE_min = 0
FE_max = 0
RK_min = 0
RK_max = 0
ZKFL_min = 0
ZKFL_max = 0
ZKZL_min = 0
ZKZL_max = 0
VZ_min = 0
VZ_max = 0

delta_FE = 0
delta_RK = 0
delta_ZKFL = 0
delta_ZKZL = 0
delta_VZ = 0

A_wr = []
A_rl = []

daten = []

me = NMesh.New()

os.system("cls")                                            ## ClearScreen
endung = ".pos"

def Hauptfunktion(filename):
    global ordner,teil_rk_hk_bb,teil_rk_hk_nn,teil_vz,teil_zk_zl,teil_ag_fl1,teil_ag_fl2,fehler_teil,fehler_tess,rk_hk_bb_type,rk_hk_nn_type
    global vz_fs_ss_type,status_teil_bb,status_teil_nn,status_teil_vz,status_teil_fl1,status_teil_fl2,status_teil_zl, ipo_fehler
    global counter1,varray,tess_ID,punkte,faktor,pi,p1,p2,p3,p4,p5,p6,endung, pfad, name, me, minmaxfiles
    global teil_cube,teil_cuboid, teil_sphere, teil_cylinder, teil_obj, tempdaten
    
    ordner = os.path.dirname(filename)                          ## Ordner auswhlen
    print ordner
    alle_dateien = os.listdir(ordner)                           ## Dateien aus Ordner einlesen
    bodyfiles = []
    
    for s in alle_dateien:                                      ## Alle Dateien mit der Endung .body
        
        if s[(len(s) - 5):] == ".body":
            bodyfiles.append(s)
        if ".minmax" in s:                                      ## Alle Dateine mit der Endung . minmax
            minmaxfiles.append(s)
        else:
            nix = 0            
    minmax()                                                    ## Einlesen der Farbwerte-Tabelle
    for i in range(len(bodyfiles)):                             ## Formatierung um den reinen Bauteil-Namen zu erhalten
        tmp = bodyfiles[i]
        bodyfiles[i] = tmp[:-5]                    
    mat_HK_BB = Material.New("HK_BB")                           ## Materialdefinition um spteren Zugriff zu erleichtern
    mat_HK_NN = Material.New("HK_NN")
    mat_VZ = Material.New("VZ")
    mat_FS = Material.New("FS")
    mat_SS = Material.New("SS")
    mat_ZK_ZL = Material.New("ZK_ZL")
    mat_GL_FL = Material.New("GL_FL")

    print bodyfiles

    for m in range(len(bodyfiles)):                             ## Abarbeitung der Teile
        pfad = ordner + "/" + str(bodyfiles[m]) +".body"        ## Pfad zur jeweiligen Datei erstellen
        datei = open(pfad, 'r')                                 ## Datei ffnen und Header auslesen


        ganzesfile = [map(lesen, line.split()) for line in datei if line.strip()]
        tempdaten = ganzesfile
        delete = []

        for n in range(len(ganzesfile)):
            if str(ganzesfile[n][0])[0] == "#":
                delete.append(n)
            else:
                nix = 0

        for k in range(len(delete)):
            del tempdaten[delete[-k-1]]
        

        typus = tempdaten[0]        
        anzahl_loop = int(tempdaten[1][0])
        datei.close()

    ## Hier werden dann die Files den einzelnen Funktionen zugewiesen. Alle Funktionen beruhen auf demselben Prinzip:
    ## Teil erstellen, mit der jeweiligen Funktion die Geometrie bertragen, Name setzen und Bewegung ber IPO geben

        if "KETSIM_RK_HK_BB" in typus:                    
            teil_rk_hk_bb = teil_rk_hk_bb+1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_RK_HK_BB()
                name = str(bodyfiles[m]) + "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,RK_min,delta_RK,0)
                me.materials.append(mat_HK_BB)
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,name)              
                status_teil_bb = status_teil_bb + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "KETSIM_RK_HK_NN" in typus:
            teil_rk_hk_nn = teil_rk_hk_nn+1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_RK_HK_NN()
                name = str(bodyfiles[m]) + "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,RK_min,delta_RK,0)
                me.materials.append(mat_HK_NN)

                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()            
                IpoCurveSet(bodyfiles[m],j+1,name)             
                status_teil_nn = status_teil_nn + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "KETSIM_VZ" in typus or "KETSIM_FS" in typus or "KETSIM_SS" in typus:
            teil_vz = teil_vz+1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_VZ()           
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                if "KETSIM_VZ" in typus:

                    FarbSet(bodyfiles[m],j+1,name,VZ_min,delta_VZ,0)
                    me.materials.append(mat_VZ)
                elif "KETSIM_FS" in typus:

                    FarbSet(bodyfiles[m],j+1,name,FE_min,delta_FE,0)
                    me.materials.append(mat_FS)
                elif "KETSIM_SS" in typus:

                    FarbSet(bodyfiles[m],j+1,name,FE_min,delta_FE,0)
                    me.materials.append(mat_SS)
                else:
                    nix = 0
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,name)
                Blender.Redraw()
                status_teil_vz = status_teil_vz + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"
              
        elif "KETSIM_ZK_ZL" in typus:
            teil_zk_zl = teil_zk_zl + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_ZK_ZL()
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,ZKZL_min,delta_ZKZL,0)
                me.materials.append(mat_ZK_ZL)
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,name)
                Blender.Redraw()
                status_teil_zl = status_teil_zl + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "KETSIM_ZK_AG_FL1" in typus:
            teil_ag_fl1 = teil_ag_fl1 + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_AG_FL1()
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,ZKFL_min,delta_ZKFL,0)
                me.materials.append(mat_GL_FL)
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,name)
                Blender.Redraw()
                status_teil_fl1 = status_teil_fl1 + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "KETSIM_ZK_AG_FL2" in typus:
            teil_ag_fl2 = teil_ag_fl2 + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                KETSIM_AG_FL2()
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,ZKFL_min,delta_ZKFL,0)
                me.materials.append(mat_GL_FL)
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,name)
                Blender.Redraw()
                status_teil_fl2 = status_teil_fl2 + 1

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "Cube" in typus:
            teil_cube = teil_cube + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                CUBE("cube")
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,0,0,"primitive")
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,"primitive")
                Blender.Redraw()

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "Cuboid" in typus:
            teil_cuboid = teil_cuboid + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                CUBE("cuboid")
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,0,0,"primitive")
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,"primitive")
                Blender.Redraw()

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "Sphere" in typus:
            teil_sphere = teil_sphere + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                openfile_primitives()
                me = Blender.Mesh.Primitives.Icosphere(5,2 * daten[6][0]*daten[5][0]*faktor)
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,0,0,"primitive")
                ob = Object.New('Mesh',name)          
                ob.link(me)
                ob.setName(name)
                sc = Blender.Scene.GetCurrent()
                sc.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,"primitive")
                Blender.Redraw()

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "Cylinder" in typus:
            teil_cylinder = teil_cylinder + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                CYLINDER()
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,0,0,"primitive")
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,"primitive")
                Blender.Redraw()

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        elif "ObjObject" in typus:
            teil_obj = teil_obj + 1
            for j in range(anzahl_loop):
                varray = []
                counter1 = 0
                me = NMesh.New()
                objpfad = ordner + "/" + tempdaten[6][0]
                name = str(bodyfiles[m]) +  "." +str(string.zfill((j+1), 4))
                FarbSet(bodyfiles[m],j+1,name,0,0,"primitive")
                OBJIMPORT(objpfad)
                ob = Object.New('Mesh',name)
                ob.link(me)
                scene = Blender.Scene.GetCurrent()
                scene.link(ob)
                Blender.Redraw()
                IpoCurveSet(bodyfiles[m],j+1,"obj")
                Blender.Redraw()

                percent2 = ((float(j) +1.0)/float(anzahl_loop))*100
                print "Unterstatus: ", str(percent2)[:5], "%"

        else:                                                   # Absicherung, falls kaputter Header oder ungltige Datei
            fehler_teil = fehler_teil +1
        
        percent = ((float(m)+1.0)/float(len(bodyfiles)))*100
        print "Status: ", str(percent)[:5] ,"%"

        


Window.FileSelector (Hauptfunktion, "Datei auswhlen!")         # Programmstart
