/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <area.h>

using namespace AMVis;
using namespace std;

Area::Area(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="Area";
  base1[0]=1.0;base1[1]=0.0; base1[2]=0.0;
  base2[0]=0.0;base2[1]=1.0; base2[2]=0.0;
  limit1=1.0;
  limit2=1.0;
}

Area::Area() : CRigidBody() {
  className="Area";
  base1[0]=1.0;base1[1]=0.0; base1[2]=0.0;
  base2[0]=0.0;base2[1]=1.0; base2[2]=0.0;
  limit1=1.0;
  limit2=1.0;
}

void Area::setBase1(float x1, float x2, float x3) {
  base1[0] = x1;
  base1[1] = x2;
  base1[2] = x3;
}

void Area::setBase2(float x1, float x2, float x3) {
  base2[0] = x1;
  base2[1] = x2;
  base2[2] = x3;
}

void Area::setLimit1(float l) {
  limit1 = l;
}

void Area::setLimit2(float l) {
  limit2 = l;
}

void Area::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Area::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<< "# Area-specific" << endl;
  (*bodyfile)<<base1[0]<<" "<<base1[1]<<" "<<base1[2]<<" "<<endl;
  (*bodyfile)<<limit1<<endl;
  (*bodyfile)<<base2[0]<<" "<<base2[1]<<" "<<base2[2]<<" "<<endl;
  (*bodyfile)<<limit2<<endl;
}
