/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef AREA_H
#define AREA_H

#include <crigidbody.h>

namespace AMVis {

//! Creates a cylinder, cone or frustum.
/*!
 * This class is used to create a cylinder, cone or frustum, which can be
 * moved and rotation in space.
*/
class Area : public CRigidBody {
public:
  //! Create a cylinder, cone or frustum.
  /*!
   * baseFilename is the basename of the body and pos file. instances is the
   * number of instances this body should create and if binPosFile is true the
   * pos file is created in binary mode or in ascii mode if false.
  */

  Area(const std::string &, int, bool);
  //! Create a cylinder, cone or frustum.
  /*!
   * Use this constructor if you want to append this body to a
   * CompoundPrimitiveBody. This constructor dose not create a body or pos
   * file.
  */
  Area();

  //! Set the base radius.
  void setBase1(float,float,float);
  //! Set the limit direction 1.
   void setLimit1(float);

  //! Set the base radius.
  void setBase2(float,float,float);
  //! Set the limit direction 2.
   void setLimit2(float);


  //! Write a cylinder, cone or frustum body file.
  virtual void writeBodyFile() const;

protected:
  float base1[3], base2[3], limit1, limit2;

  void writeToBodyFile(std::ofstream *) const;
};

}

#endif
