/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <arrow.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

Arrow::Arrow(const string &base, int num, bool bin) : CBody(base, num, bin) {
  className="Arrow";
  length=0.04;
  diameterhead=0.02;
  diameter=0.01;
  type=1;
  scaleFactor=1;
}

void Arrow::setArrowHead(float diameter_, float length_) {
  diameterhead=diameter_;
  length=length_;
}

void Arrow::setDiameter(float diameter_) {
  diameter=diameter_;
}

void Arrow::setType(int type_) {
  type=type_;
}

void Arrow::setScaleFactor(float scale) {
  scaleFactor=scale;
}

void Arrow::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Arrow::writeToBodyFile(ofstream *bodyfile) const {
  CBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# diameter of arrow"<<endl;
  (*bodyfile)<<diameter<<endl;
  (*bodyfile)<<"# diameter of arrowhead"<<endl;
  (*bodyfile)<<diameterhead<<endl;
  (*bodyfile)<<"# length of arrowhead"<<endl;
  (*bodyfile)<<length<<endl;
  (*bodyfile)<<"# type: 0=no head; 1=only to-head; 2=only from-head; 3=from- and to-head"<<endl;
  (*bodyfile)<<type<<endl;
  (*bodyfile)<<"# scale factor arrow length"<<endl;
  (*bodyfile)<<scaleFactor<<endl;
}

void Arrow::appendDataset(int ind) const {
  if(binaryPosFile==false) {
    posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<t<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<x<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<y<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<z<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<dx<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<dy<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<dz<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<c<<endl;
  }
  else {
    posfile[ind].write((char*)&t, sizeof(float));
    posfile[ind].write((char*)&x, sizeof(float));
    posfile[ind].write((char*)&y, sizeof(float));
    posfile[ind].write((char*)&z, sizeof(float));
    posfile[ind].write((char*)&dx, sizeof(float));
    posfile[ind].write((char*)&dy, sizeof(float));
    posfile[ind].write((char*)&dz, sizeof(float));
    posfile[ind].write((char*)&c, sizeof(float));
  }
  if(flush) posfile[ind].flush();
}

void Arrow::setTime(float time) {
  t=time;
}

void Arrow::setToPoint(float x_, float y_, float z_) {
  x=x_;
  y=y_;
  z=z_;
}

void Arrow::setDirection(float dx_, float dy_, float dz_) {
  dx=dx_;
  dy=dy_;
  dz=dz_;
}

void Arrow::setColor(float color) {
  c=color;
}
