/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <cbody.h>
#include <sstream>
#include <iomanip>
#include <iostream>
#ifdef ANSICSIGNAL
#  include <signal.h>
#endif

using namespace AMVis;
using namespace std;

bool CBody::init=false;
bool CBody::flush=true;

CBody::CBody(const string &base, int num, bool bin) {
  writePosFileInfo=true;
  className="CBody";
  baseFilename=base;
  instances=num;
  posfile=new ofstream[instances];
  for(int i=0; i<instances; ++i) {
    ostringstream posFilename;
    posFilename<<baseFilename<<"."<<setw(4)<<setfill('0')<<i+1<<".pos";
    posfile[i].open(posFilename.str().c_str());
    posfile[i].setf(ios::scientific);
    posfile[i].precision(AMVIS_FLOAT_PRECISION);
  }
  binaryPosFile=bin;
  flush=true;
#ifdef ANSICSIGNAL
  if(!init) signal(SIGUSR1, sigUSR1Handler);
#endif
  init=true;
}

CBody::CBody() {
  writePosFileInfo=false;
  className="CBody";
  baseFilename="";
  instances=0;
  posfile=NULL;
  binaryPosFile=false;
  flush=true;
#ifdef ANSICSIGNAL
  if(!init) signal(SIGUSR1, sigUSR1Handler);
#endif
  init=true;
}

CBody::~CBody() {
  for(int i=0; i<instances;++i)
    posfile[i].close();
  delete[]posfile; posfile=NULL;
}

ofstream *CBody::openBodyFile() const {
  ofstream *bodyfile=new ofstream;
  bodyfile->open((baseFilename+".body").c_str());
  return bodyfile;
}

void CBody::closeBodyFile(ofstream *bodyfile) const {
  bodyfile->close();
  delete bodyfile; bodyfile=NULL;
}

void CBody::writeToBodyFile(ofstream *bodyfile) const {
    (*bodyfile)<<"# Created by AMVisC++Interface"<<endl;
    (*bodyfile)<<className<<endl;
  if(writePosFileInfo==true) {
    (*bodyfile)<<"# number of instances"<<endl;
    (*bodyfile)<<instances<<endl;
    (*bodyfile)<<"# pos-file is binary=1 (datatype float) or ascii=0"<<endl;
    (*bodyfile)<<binaryPosFile<<endl;
  }
}

#ifdef ANSICSIGNAL
void CBody::sigUSR1Handler(int) {
  if(flush) {
    flush=false;
    cout<<"AMVis-C++Interface: Flushing of pos-files disabled."<<endl;
  } else {
    flush=true;
    cout<<"AMVis-C++Interface: Flushing of pos-files enabled."<<endl;
  }
}
#endif
