/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CBODY_H
#define CBODY_H

#include <string>
#include <fstream>

namespace AMVis {

#define AMVIS_FLOAT_PRECISION 6
#define AMVIS_FLOAT_WIDTH 14

//! Abstract base class for all AMVis bodies.
class CBody {
public:
  //! Pure virtual function writing the body file.
  /*!
   * This functin is called to write the body file of the current body to disk.
  */
  virtual void writeBodyFile() const=0;

  //! Pure virtual function appending a dataset to a pos file.
  /*!
   * This function is called to append a new dataset to the pos file with
   * index ind. ind runs from 0 to instances-1.
  */
  virtual void appendDataset(int ind) const=0;

  CBody(const std::string &baseFilename, int instances, bool binPosFile);
  CBody();
  virtual ~CBody();
protected:
  bool writePosFileInfo;
  std::string className;
  std::string baseFilename;
  int instances;
  bool binaryPosFile;
  std::ofstream *posfile;

  std::ofstream *openBodyFile() const;
  void closeBodyFile(std::ofstream *bodyfile) const;
  virtual void writeToBodyFile(std::ofstream *bodyfile) const;
  static bool flush;
private:
  static bool init;
#ifdef ANSICSIGNAL
  static void sigUSR1Handler(int);
#endif
};

}

#endif
