/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <coilspring.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

CoilSpring::CoilSpring(const string &base, int num, bool bin) : CBody(base, num, bin) {
  className="CoilSpring";
  rCrossSection =0.0;
  rSpring = 0.0;
  c=0;
  nCoils = 1.0;
  scaleFactor=1;
}

void CoilSpring::setNumberOfCoils(float nCoils_) {
  nCoils = nCoils_;
}

void CoilSpring::setRadius(float r_) {
  rSpring = r_;
}

void CoilSpring::setRadiusCrossSection(float rCrossSection_) {
  rCrossSection = rCrossSection_;
}


void CoilSpring::setScaleFactor(float scale) {
  scaleFactor=scale;
}

void CoilSpring::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void CoilSpring::writeToBodyFile(ofstream *bodyfile) const {
  CBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# number of Coils"<<endl;
  (*bodyfile)<<nCoils<<endl;
  (*bodyfile)<<"# radius of coil"<<endl;
  (*bodyfile)<<rSpring<<endl;
  (*bodyfile)<<"# radius of cross section"<<endl;
  (*bodyfile)<<rCrossSection<<endl;
  (*bodyfile)<<"# scale factor"<<endl;
  (*bodyfile)<<scaleFactor<<endl;
}

void CoilSpring::appendDataset(int ind) const {
  if(binaryPosFile==false) {
    posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<t<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<xFrom<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<yFrom<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<zFrom<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<xTo<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<yTo<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<zTo<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<c<<endl;
  }
  else {
    posfile[ind].write((char*)&t, sizeof(float));
    posfile[ind].write((char*)&xFrom, sizeof(float));
    posfile[ind].write((char*)&yFrom, sizeof(float));
    posfile[ind].write((char*)&zFrom, sizeof(float));
    posfile[ind].write((char*)&xTo, sizeof(float));
    posfile[ind].write((char*)&yTo, sizeof(float));
    posfile[ind].write((char*)&zTo, sizeof(float));
    posfile[ind].write((char*)&c, sizeof(float));
  }
  if(flush) posfile[ind].flush();
}

void CoilSpring::setTime(float time) {
  t=time;
}

void CoilSpring::setToPoint(float x_, float y_, float z_) {
  xTo=x_;
  yTo=y_;
  zTo=z_;
}

void CoilSpring::setFromPoint(float x_, float y_, float z_) {
  xFrom=x_;
  yFrom=y_;
  zFrom=z_;
}

void CoilSpring::setColor(float color) {
  c=color;
}
