/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <compoundprimitivebody.h>

using namespace AMVis;
using namespace std;

CompoundPrimitiveBody::CompoundPrimitiveBody(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="CompoundPrimitiveBody";
}

CompoundPrimitiveBody::~CompoundPrimitiveBody() {
  vector<CRigidBody*>::iterator i;
  for(i=bodies.begin(); i!=bodies.end(); i++){
    delete *i; *i= 0;
  }
}

void CompoundPrimitiveBody::addBody(CRigidBody *body) {
  bodies.push_back(body);
}

void CompoundPrimitiveBody::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void CompoundPrimitiveBody::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<endl;
  (*bodyfile)<<endl;
  (*bodyfile)<<"# Definition of primitiv Compounds with type: "<<endl;  
  (*bodyfile)<<"# 'Cube', 'Cuboid', 'Cylinder', 'Sphere', 'Torus', 'ObjObject', 'Extrusion', 'Rotation'"<<endl;
  (*bodyfile)<<"# Parameters initial translation (x y z), rotation (alpha beta gamma; kardan angle; radian) and scale factor are relative"<<endl;
  (*bodyfile)<<endl;
  int iCompound=1;
  vector<CRigidBody*>::const_iterator i;
  for(i=bodies.begin(); i!=bodies.end(); i++) {
    (*bodyfile)<<"# definition of the " << iCompound<<". primitiv body"<<endl;
      iCompound++;
    (*i)->writeToBodyFile(bodyfile);
    (*bodyfile)<<endl;
  }
}
