/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMPOUNDPRIMITIVEBODY_H
#define COMPOUNDPRIMITIVEBODY_H

#include <crigidbody.h>
#include <vector>

namespace AMVis {

//! Creates a compound primitive body.
/*!
 * This class is used to create a body which is a compound of primitive rigid
 * bodies.
*/
class CompoundPrimitiveBody : public CRigidBody {
public:
  //! Create a compound primitive body.
  /*!
   * baseFilename is the basename of the body and pos file. instances is the
   * number of instances this body should create and if binPosFile is true the
   * pos file is created in binary mode or in ascii mode if false.
  */
  CompoundPrimitiveBody(const std::string &, int, bool);
  virtual ~CompoundPrimitiveBody();
  //! Add a new rigid body.
  /*!
   * The rigid body body is added to the compound. Valid bodies are currently
   * Cube, Cuboid, Cylinder, Extrusion, ObjObject, Rotation, Sphere and Torus.
  */
  void addBody(CRigidBody *body);

  //! Write a compound primitive body file.
  virtual void writeBodyFile() const;

protected:
  std::vector<CRigidBody*> bodies;

  void writeToBodyFile(std::ofstream *) const;
};

}

#endif
