/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <crigidbody.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

CRigidBody::CRigidBody(const string &base, int num, bool bin) : CBody(base, num, bin) {
  className="CRigidBody";
  initialTranslation[0]=0;
  initialTranslation[1]=0;
  initialTranslation[2]=0;
  initialRotation[0]=0;
  initialRotation[1]=0;
  initialRotation[2]=0;
  scaleFactor=1;

  t=0;
  translation[0]=0;
  translation[1]=0;
  translation[2]=0;
  rotation[0]=0;
  rotation[1]=0;
  rotation[2]=0;
  color=0;
}

CRigidBody::CRigidBody() : CBody() {
  className="CRigidBody";
  initialTranslation[0]=0;
  initialTranslation[1]=0;
  initialTranslation[2]=0;
  initialRotation[0]=0;
  initialRotation[1]=0;
  initialRotation[2]=0;
  scaleFactor=1;

  t=0;
  translation[0]=0;
  translation[1]=0;
  translation[2]=0;
  rotation[0]=0;
  rotation[1]=0;
  rotation[2]=0;
  color=0;
}

void CRigidBody::setInitialTranslation(float x, float y, float z) {
  initialTranslation[0]=x;
  initialTranslation[1]=y;
  initialTranslation[2]=z;
}

void CRigidBody::setInitialRotation(float alpha, float beta, float gamma) {
  initialRotation[0]=alpha;
  initialRotation[1]=beta;
  initialRotation[2]=gamma;
}

void CRigidBody::setScaleFactor(float scale) {
  scaleFactor=scale;
}

void CRigidBody::writeToBodyFile(ofstream *bodyfile) const {
  CBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# initial translation of the body [Rx  Ry  Rz]T"<<endl;
  (*bodyfile)<<initialTranslation[0]<<" "
    <<initialTranslation[1]<<" "
    <<initialTranslation[2]<<endl;
  (*bodyfile)<<"# initial rotation of the body [alpha  beta  gamma]T  (radian)"<<endl;	     
  (*bodyfile)<<initialRotation[0]<<" "
    <<initialRotation[1]<<" "
    <<initialRotation[2]<<endl;
  (*bodyfile)<<"# scale factor of the body"<<endl;	     
  (*bodyfile)<<scaleFactor<<endl;
}

void CRigidBody::setTime(float t_) {
  t=t_;
}

void CRigidBody::setTranslation(float x, float y, float z) {
  translation[0]=x;
  translation[1]=y;
  translation[2]=z;
}

void CRigidBody::setRotation(float alpha, float beta, float gamma) {
  rotation[0]=alpha;
  rotation[1]=beta;
  rotation[2]=gamma;
}

void CRigidBody::setColor(float c) {
  color=c;
}

void CRigidBody::appendDataset(int ind) const {
  if(binaryPosFile==false) {
    posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<t<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<translation[0]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<translation[1]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<translation[2]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<rotation[0]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<rotation[1]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<rotation[2]<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<color<<endl;
  }
  else {
    posfile[ind].write((char*)&t, sizeof(float));
    posfile[ind].write((char*)translation, 3*sizeof(float));
    posfile[ind].write((char*)rotation, 3*sizeof(float));
    posfile[ind].write((char*)&color, sizeof(float));
  }
  if(flush) posfile[ind].flush();
}
