/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <cuboid.h>

using namespace AMVis;
using namespace std;

Cuboid::Cuboid(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="Cuboid";
  lengthx=0.01;
  lengthy=0.01;
  lengthz=0.01;
}

Cuboid::Cuboid() : CRigidBody() {
  className="Cuboid";
  lengthx=0.01;
  lengthy=0.01;
  lengthz=0.01;
}

void Cuboid::setSize(float lenx, float leny, float lenz) {
  lengthx=lenx;
  lengthy=leny;
  lengthz=lenz;
}

void Cuboid::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Cuboid::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# length Lx of the cuboid"<<endl;
  (*bodyfile)<<lengthx<<endl;
  (*bodyfile)<<"# length Ly of the cuboid"<<endl;
  (*bodyfile)<<lengthy<<endl;
  (*bodyfile)<<"# length Lz of the cuboid"<<endl;
  (*bodyfile)<<lengthz<<endl;
}
