/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <cylinder.h>

using namespace AMVis;
using namespace std;

Cylinder::Cylinder(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="Cylinder";
  baseRadius=0.01;
  topRadius=0.01;
  height=0.02;
  innerBaseRadius=0.0;
  innerTopRadius= 0.0;
}

Cylinder::Cylinder() : CRigidBody() {
  className="Cylinder";
  baseRadius=0.01;
  topRadius=0.01;
  height=0.02;
  innerBaseRadius=0.0;
  innerTopRadius =0.0;
}

void Cylinder::setBaseRadius(float rad) {
  baseRadius=rad;
}

void Cylinder::setTopRadius(float rad) {
  topRadius=rad;
}

void Cylinder::setHeight(float h) {
  height=h;
}

void Cylinder::setInnerBaseRadius(float rad) {
  innerBaseRadius=rad;
}

void Cylinder::setInnerTopRadius(float rad) {
  innerTopRadius=rad;
}

void Cylinder::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Cylinder::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# base radius"<<endl;
  (*bodyfile)<<baseRadius<<endl;
  (*bodyfile)<<"# top radius"<<endl;
  (*bodyfile)<<topRadius<<endl;
  (*bodyfile)<<"# height"<<endl;
  (*bodyfile)<<height<<endl;
  (*bodyfile)<<"# inner base radius"<<endl;
  (*bodyfile)<<innerBaseRadius<<endl;
  (*bodyfile)<<"# inner top radius"<<endl;
  (*bodyfile)<<innerTopRadius<<endl;
}
