/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <elastic.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

ElasticBody::ElasticBody(const string &base, int num, bool bin) : CBody(base, num, bin), dofs(0), color(0.0) {
  className="ElasticBody";
}

ElasticBody::ElasticBody() : CBody() {
  className="ElasticBody";
}

void ElasticBody::setInitialTranslation(float x, float y, float z) {
  initialTranslation[0]=x;
  initialTranslation[1]=y;
  initialTranslation[2]=z;
}

void ElasticBody::setTime(float t_) {
  t=t_;
}

void ElasticBody::setCoordinates(float *q_) {
    for(int i=0;i<dofs;i++)
	q[i] = q_[i];
}

void ElasticBody::setColor(float c) {
  color=c;
}

void ElasticBody::writeToBodyFile(ofstream *bodyfile) const {
  CBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# Color\n"<<color<<endl;
}

void ElasticBody::appendDataset(int ind) const {
    if(binaryPosFile==false) {
	posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<t<<" ";
	for(int i=0;i<dofs;i++) posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<q[i]<<" ";
//	posfile[ind]	                    <<setw(AMVIS_FLOAT_WIDTH)<<color;
	posfile[ind]                        <<endl;
    }
    else {
	posfile[ind].write((char*)&t    ,      sizeof(float));
	posfile[ind].write((char*)q     , dofs*sizeof(float));
//    posfile[ind].write((char*)&color,   sizeof(float));
    }
    if(flush) posfile[ind].flush();
}
