/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef ELASTICBODY_H
#define ELASTICBODY_H

#include <cbody.h>
#include <fstream>

namespace AMVis {

  //! Base class for all rigid bodies.
  class ElasticBody : public CBody {

    public:
      //! Set the initial translation.
      /*!
       * x, y and z are the initial translation values of the rigid body.
       */
      void setInitialTranslation(float x, float y, float z);

      //! Set the current simulation time.
      void setTime(float time);

      //! Set the translation.
      /*!
       * \param q_ are the translation values of the rigid body at the time given
       * by AMVis::ElasticBody1sRCM::setTime.
       */
      void setCoordinates(float *q_);

      //! Set the color.
      /*!
       * color is the color of the rigid body at the time given by
       * AMVis::ElasticBody1sRCM::setTime.
       * color runs from 0.0=blue over 0.25=cyan over 0.5=green over 0.75=magenta
       * to 1.0=red.
       */
      void setColor(float color);

      //! Append a dataset to the pos file.
      /*!
       * Appends the current dataset (set with AMVis::ElasticBody1sRCM::setTime,
       * AMVis::ElasticBody1sRCM::setCoordinates
       * and AMVis::ElasticBody1sRCM::setColor) to the pos file with index ind. ind runs from 0 to
       * instances-1.
       */
      void appendDataset(int ind) const;

    protected:
      ElasticBody(const std::string &, int, bool);
      ElasticBody();
      float initialTranslation[3];

      float t;
      float *q;
      float color;

      /*! number of degrees of freedom
      */
      int dofs;

      void writeToBodyFile(std::ofstream *bodyfile) const;
  };

}

#endif
