/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <elastic1s21rcm.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

ElasticBody1s21RCM::ElasticBody1s21RCM(const string &base, int n_, bool openStructure_, int num, bool bin) : ElasticBody(base, num, bin), n(n_), openStructure(openStructure_) {
  className="ElasticBody1s21RCM";
  initialTranslation[0]=0;
  initialTranslation[1]=0;
  initialTranslation[2]=0;

  JT[0][0]=0;  JT[0][1]=0;
  JT[1][0]=0;  JT[1][1]=0;
  JT[2][0]=0;  JT[2][1]=0;

  JR[0]=0;
  JR[1]=0;
  JR[2]=0;

  t=0;
  
  if(openStructure) dofs = 5*n + 3;
  else              dofs = 5*n    ;

  q = new float[dofs];

  color=0.;
}

void ElasticBody1s21RCM::setCylinder(float cylinderRadius_)
{
	// SETCYLINDER elects the contour of a FE-Beam
	// INPUT	cylinderRadius_	Radius of the cylinder
	
	cylinderRadius = cylinderRadius_;
}

void ElasticBody1s21RCM::setCuboid(float cuboidBreadth_,float cuboidHeight_)
{
	// SETCUBOID elects the contour of a FE-Beam
	// INPUT	cuboidBreadth_	Breadth of the cuboid
	//			cuboidHeight_	Height of the cuboid
	
	cuboidBreadth = cuboidBreadth_;
	cuboidHeight = cuboidHeight_;
}

ElasticBody1s21RCM::ElasticBody1s21RCM() : ElasticBody() {
  className="ElasticBody1s21RCM";
}

void ElasticBody1s21RCM::setJacobians(float JT_[3][2], float JR_[3]) {
    JT[0][0] = JT_[0][0];
    JT[1][0] = JT_[1][0];
    JT[2][0] = JT_[2][0];

    JT[0][1] = JT_[0][1];
    JT[1][1] = JT_[1][1];
    JT[2][1] = JT_[2][1];

    JR[0]    = JR_[0];
    JR[0]    = JR_[0];
    JR[0]    = JR_[0];
}

void ElasticBody1s21RCM::writeBodyFile() const {
    ofstream *bodyfile=openBodyFile();
    writeToBodyFile(bodyfile);
    closeBodyFile(bodyfile);
}


void ElasticBody1s21RCM::writeToBodyFile(ofstream *bodyfile) const {
  ElasticBody::writeToBodyFile(bodyfile);

  (*bodyfile)<<"# Elements\n"<<n<<endl;
  
  if(openStructure) (*bodyfile)<<"# Open(o) or Closed(c)\no"<<endl;
  else              (*bodyfile)<<"# Open(o) or Closed(c)\nc"<<endl;

  (*bodyfile)<<"# l0\n"<<l0<<endl;

  (*bodyfile)<<"# WrON00\n"
	     <<initialTranslation[0]<<" "
             <<initialTranslation[1]<<" "
	     <<initialTranslation[2]<<endl;

  (*bodyfile)<<"# JT\n"
	     <<JT[0][0]<<" " <<JT[0][1]<<endl
	     <<JT[1][0]<<" " <<JT[1][1]<<endl
	     <<JT[2][0]<<" " <<JT[2][1]<<endl;

  (*bodyfile)<<"# JR\n"
	     <<JR[0]<<" "<<JR[1]<<" "<<JR[2]<<endl;

  const float flag = -1.;   
  if(cylinderRadius > 0.) (*bodyfile)<<"# CylinderRadius\n"<<cylinderRadius<<" "<<flag        <<endl;
  else			  (*bodyfile)<<"# Cuboid\n"        <<cuboidBreadth <<" "<<cuboidHeight<<endl;
}

void ElasticBody1s21RCM::setElementLength(float l0_) {
  l0=l0_;
}
