/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef ELASTICBODY1S21RCM_H
#define ELASTICBODY1S21RCM_H

#include <elastic.h>
#include <fstream>

namespace AMVis {

  //! Class for bodies with RCM
  class ElasticBody1s21RCM : public ElasticBody {

    public:
      ElasticBody1s21RCM(const std::string &, int n_, bool closed_,int, bool);
      ElasticBody1s21RCM();

      /*! Set the Jacobians for translations and rotations.
      */
      void setJacobians(float JT_[3][2], float JR_[3]);

      /*! set element lenght
      */
      void setElementLength(float l0_);

      /*! Elects the cylinder contour of a FE-Beam (Priority 1) */
      void setCylinder(float cylinderRadius_);

      /*! Elects the cuboid contour of a FE-Beam (Priority 2) or the neutral fibre contour (Priority 3) */
      void setCuboid(float cuboidBeadth_,float cuboidHeight_);

      void writeBodyFile() const;

    protected:
      float JT[3][2], JR[3];

      /*! number of elements
      */
      int n;
      /*! open or closed structure
      */
      bool openStructure;
      /*! element length
      */
      float l0;
      /*! Cylinder or cuboid */
      float cylinderRadius;
      /*! Cylinder or cuboid*/
      float cuboidBreadth, cuboidHeight;

      void writeToBodyFile(std::ofstream *bodyfile) const;

  };

}

#endif
