/*
 * AMVisC++Interface - C++ Interface for Body- and Pos-File Creation used by AMVis
 * Copyright (C) 2006 Institute of Applied Mechanics,
 *                    Technical University of Munich

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  03311-1307  USA
 */
 
/* 
 * (c) 2006-08  Thorsten Schindler
 * Contact: schindler@amm.mw.tum.de
 * 
 * VERSION 14.01.08
 */
 
#include <config.h>
#include "elastic1s33rcm.h"
using namespace AMVis;
using namespace std;

ElasticBody1s33RCM::ElasticBody1s33RCM(const string& base_,int n_,bool openStructure_,int num_,bool bin_) : ElasticBody(base_,num_,bin_),
	n(n_),openStructure(openStructure_),cylinderRadius(0.),cuboidBreadth(0.),cuboidHeight(0.),l0(0.)
{	
	className = "ElasticBody1s33RCM";
	
	initialTranslation[0] = 0.;
	initialTranslation[1] = 0.;
	initialTranslation[2] = 0.;

  	Jac[0][0] = 0.; Jac[0][1] = 0.; Jac[0][2] = 0.;
  	Jac[1][0] = 0.; Jac[1][1] = 0.; Jac[1][2] = 0.;
  	Jac[2][0] = 0.; Jac[2][1] = 0.; Jac[2][2] = 0.;
	
  	t = 0.; // time
  
  	if(openStructure) dofs = 10*n + 6;
  	else              dofs = 10*n;

  	q = new float[dofs];

  	color = 1.;
}

ElasticBody1s33RCM::ElasticBody1s33RCM() : ElasticBody(),
	n(0),openStructure(true),cylinderRadius(0.),cuboidBreadth(0.),cuboidHeight(0.),l0(0.)
{	
  	className = "ElasticBody1s33RCM";
  	
  	Jac[0][0] = 0.; Jac[0][1] = 0.; Jac[0][2] = 0.;
  	Jac[1][0] = 0.; Jac[1][1] = 0.; Jac[1][2] = 0.;
  	Jac[2][0] = 0.; Jac[2][1] = 0.; Jac[2][2] = 0.;
}

ElasticBody1s33RCM::~ElasticBody1s33RCM() {}
 
void ElasticBody1s33RCM::setJacobian(float Jac_[3][3])
{	
    Jac[0][0] = Jac_[0][0]; Jac[1][0] = Jac_[1][0]; Jac[2][0] = Jac_[2][0];
    Jac[0][1] = Jac_[0][1]; Jac[1][1] = Jac_[1][1]; Jac[2][1] = Jac_[2][1];
    Jac[0][2] = Jac_[0][2]; Jac[1][2] = Jac_[1][2]; Jac[2][2] = Jac_[2][2];
} 
 
void ElasticBody1s33RCM::setElementLength(float l0_) {l0 = l0_;}

void ElasticBody1s33RCM::setCylinder(float cylinderRadius_) {cylinderRadius = cylinderRadius_;}

void ElasticBody1s33RCM::setCuboid(float cuboidBreadth_,float cuboidHeight_)
{
	cuboidBreadth = cuboidBreadth_;
	cuboidHeight = cuboidHeight_;
}

void ElasticBody1s33RCM::writeBodyFile() const
{
    ofstream *bodyfile = openBodyFile();
    writeToBodyFile(bodyfile);
    closeBodyFile(bodyfile);
}

void ElasticBody1s33RCM::writeToBodyFile(ofstream *bodyfile) const
{
  	ElasticBody::writeToBodyFile(bodyfile);

  	(*bodyfile) << "# Elements\n" << n << endl;
  
  	if(openStructure) (*bodyfile) << "# Open(o) or Closed(c)\no" << endl;
  	else              (*bodyfile) << "# Open(o) or Closed(c)\nc" << endl;

  	(*bodyfile) << "# l0\n" << l0 << endl;
  	
  	(*bodyfile) << "# WrON00\n"
				<< initialTranslation[0] << " " << initialTranslation[1] << " " << initialTranslation[2] << endl;

  	(*bodyfile) << "# Jac\n"
				<< Jac[0][0] <<" " << Jac[0][1] << " " << Jac[0][2] << endl
				<< Jac[1][0] <<" " << Jac[1][1] << " " << Jac[1][2] << endl
				<< Jac[2][0] <<" " << Jac[2][1] << " " << Jac[2][2] << endl;
	
	float flag = -1.;   
	if(cylinderRadius > 0.) 	(*bodyfile) << "# CylinderRadius\n" << cylinderRadius << " " << flag << endl;
	else						(*bodyfile) << "# Cuboid\n" << cuboidBreadth << " " << cuboidHeight << endl;
}
