/*
 * AMVisC++Interface - C++ Interface for Body- and Pos-File Creation used by AMVis
 * Copyright (C) 2006 Institute of Applied Mechanics,
 *                    Technical University of Munich

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 
 * (c) 2006-08  Thorsten Schindler
 * Contact: schindler@amm.mw.tum.de
 * 
 * VERSION 14.01.08
 */

#ifndef ELASTICBODY1S33RCM_H
#define ELASTICBODY1S33RCM_H

#include "elastic.h"

namespace AMVis {

  /*! \brief INTERFACE FOR VISUALISATION OF Body1s33RCM */
  class ElasticBody1s33RCM : public ElasticBody {

    public:
      /*! Constructor with name \param base_, number of instances \param num_ and FLAG for binary pos-file \param bin_ */
      ElasticBody1s33RCM(const std::string& base_,int n_,bool openStructure_,int num_,bool bin_);
      /*! Constructor */
      ElasticBody1s33RCM();
      /*! Destructor */
      virtual ~ElasticBody1s33RCM();

      /*! Sets the trafo inertial FR <- body inertial FR */
      void setJacobian(float Jac_[3][3]); 			
      /*! Sets the length of a FE */
      void setElementLength(float l0_);  			
      /*! Elects the cylinder contour of a FE (priority 1) */
      void setCylinder(float cylinderRadius_);  			
      /*! Elects the cuboid contour of a FE (priority 2) or the neutral fibre contour (priority 3) */
      void setCuboid(float cuboidBeadth_,float cuboidHeight_);

      /*! Creates a body-file */
      void writeBodyFile() const;

    private:
      /** trafo inertial FR <- body inertial FR */
      float Jac[3][3];

      /** number of FE */
      int n;

      /**  open or closed structure */
      bool openStructure;

      /** cylinder or cuboid */
      float cylinderRadius;
      float cuboidBreadth, cuboidHeight;

      /** FE length */
      float l0;

      /*! Creates a body-file */
      void writeToBodyFile(std::ofstream *bodyfile) const;
  };
}

#endif /* ELASTICBODY1S33RCM_H */
