/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <elastic1sbta.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

ElasticBody1sBTA::ElasticBody1sBTA(const string &base, int n_, int num, bool bin) : ElasticBody(base, num, bin), n(n_) {
  className="ElasticBody1sBTA";
  initialTranslation[0]=0;
  initialTranslation[1]=0;
  initialTranslation[2]=0;

  J[0][0]=0;  J[0][1]=0;   J[0][2]=0;
  J[1][0]=0;  J[1][1]=0;   J[1][2]=0;
  J[2][0]=0;  J[2][1]=0;   J[2][2]=0;

  t=0;
  
  dofs = 5*(n+1);

  q = new float[dofs];

  color=0;
}

ElasticBody1sBTA::ElasticBody1sBTA() : ElasticBody() {
  className="ElasticBody1sBTA";
}

void ElasticBody1sBTA::setJacobian(float J_[3][3]) {
    J[0][0] = J_[0][0];
    J[1][0] = J_[1][0];
    J[2][0] = J_[2][0];

    J[0][1] = J_[0][1];
    J[1][1] = J_[1][1];
    J[2][1] = J_[2][1];

    J[0][2] = J_[0][2];
    J[1][2] = J_[1][2];
    J[2][2] = J_[2][2];
}

void ElasticBody1sBTA::writeBodyFile() const {
    ofstream *bodyfile=openBodyFile();
    writeToBodyFile(bodyfile);
    closeBodyFile(bodyfile);
}


void ElasticBody1sBTA::writeToBodyFile(ofstream *bodyfile) const {
  ElasticBody::writeToBodyFile(bodyfile);

  (*bodyfile)<<"# Elements\n"<<n<<endl;
  
  (*bodyfile)<<"# l0\n"<<l0<<endl;

  (*bodyfile)<<"# WrON00\n"
	     <<initialTranslation[0]<<" "
             <<initialTranslation[1]<<" "
	     <<initialTranslation[2]<<endl;

  (*bodyfile)<<"# J\n"
	     <<J[0][0]<<" " <<J[0][1]<<" " <<J[0][2]<<endl
	     <<J[1][0]<<" " <<J[1][1]<<" " <<J[1][2]<<endl
	     <<J[2][0]<<" " <<J[2][1]<<" " <<J[2][2]<<endl;

  (*bodyfile)<<"# r\n"
	     <<r << endl;
}

void ElasticBody1sBTA::setElementLength(float l0_) {
  l0=l0_;
}
