/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef ELASTICBODY1SBTA_H
#define ELASTICBODY1SBTA_H

#include <elastic.h>
#include <fstream>

namespace AMVis {

  //! Class for bodies with RCM
  class ElasticBody1sBTA : public ElasticBody {

    public:
      ElasticBody1sBTA(const std::string &, int n_, int, bool);
      ElasticBody1sBTA();

      /*! Set the Jacobians for translations and rotations.
      */
      void setJacobian(float J_[3][3]);

      /*! set element lenght
      */
      void setElementLength(float l0_);
      double r;
      /*! set radius of axis
      */
      void setRadius(float r_) {r = r_;}

      void writeBodyFile() const;

    protected:
      float J[3][3];

      /*! number of elements
      */
      int n;
      /*! element length
      */
      float l0;

      void writeToBodyFile(std::ofstream *bodyfile) const;

  };

}

#endif
