/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <elastic2s13disk.h>
//#include <iomanip>
#include <fstream>

using namespace AMVis;
using namespace std;

ElasticBody2s13Disk::ElasticBody2s13Disk(const string &base, int nr_, int nj_, int num, bool bin) : ElasticBody(base, num, bin), nr(nr_), nj(nj_), nElements(nr*nj), nNodes((nr+1) * nj) {
  className="ElasticBody2s13Disk";
  initialTranslation[0]=0;
  initialTranslation[1]=0;
  initialTranslation[2]=0;

  JT[0][0]=0;  JT[0][1]=0;
  JT[1][0]=0;  JT[1][1]=0;
  JT[2][0]=0;  JT[2][1]=0;

  t=0;
  
  dofs = 4*nNodes + 2;

  q = new float[dofs];

  color=0;
}

ElasticBody2s13Disk::ElasticBody2s13Disk() : ElasticBody() {
  className="ElasticBody2s13Disk";
}

void ElasticBody2s13Disk::setJacobian(float JT_[3][3]) {
  JT[0][0] = JT_[0][0];  JT[0][1] = JT_[0][1];  JT[0][2] = JT_[0][2];
  JT[1][0] = JT_[1][0];  JT[1][1] = JT_[1][1];  JT[1][2] = JT_[1][2];
  JT[2][0] = JT_[2][0];  JT[2][1] = JT_[2][1];  JT[2][2] = JT_[2][2];
}

void ElasticBody2s13Disk::setRadii(float Ri_, float Ra_) {
  Ri = Ri_; Ra = Ra_;
}

void ElasticBody2s13Disk::setThickness(float di_[3],float da_[3]) {
  di[0] = di_[0]; di[1] = di_[1]; di[2] = di_[2];
  da[0] = da_[0]; da[1] = da_[1]; da[2] = da_[2];
}

void ElasticBody2s13Disk::writeBodyFile() const {
    ofstream *bodyfile=openBodyFile();
    writeToBodyFile(bodyfile);
    closeBodyFile(bodyfile);
}
 
void ElasticBody2s13Disk::setNodeCoordinates(NodeCoordinates NC_[]) {
  NC = new NodeCoordinates[nNodes];
  for (int i=0;i<nNodes;i++) {
	NC[i].r = NC_[i].r;
	NC[i].j = NC_[i].j;
  }
}

void ElasticBody2s13Disk::setElementNodeList(ElementNodeList ENL_[]) {
  ENL = new ElementNodeList[nElements];
  for (int i=0;i<nElements;i++) {
	ENL[i].node0 = ENL_[i].node0;
	ENL[i].node1 = ENL_[i].node1;
	ENL[i].node2 = ENL_[i].node2;
	ENL[i].node3 = ENL_[i].node3;
  }
}

void ElasticBody2s13Disk::writeToBodyFile(ofstream *bodyfile) const {
  ElasticBody::writeToBodyFile(bodyfile);

  (*bodyfile)<<"# nr\n"<<nr<<endl;
  (*bodyfile)<<"# nj\n"<<nj<<endl;
  (*bodyfile)<<"# Elements\n"<<nElements<<endl;
  (*bodyfile)<<"# Nodes\n"<<nNodes<<endl;

  (*bodyfile)<<"# Ri Ra\n"<<Ri<<" "<<Ra<<endl;

  (*bodyfile)<<"# di"<<endl;
  for(int i=0;i<3;i++) (*bodyfile)<<" "<<di[i]; (*bodyfile)<<endl;
  (*bodyfile)<<"# da"<<endl;
  for(int i=0;i<3;i++) (*bodyfile)<<" "<<da[i]; (*bodyfile)<<endl;

  (*bodyfile)<<"# WrON00\n"
	     <<initialTranslation[0]<<" "
         <<initialTranslation[1]<<" "
	     <<initialTranslation[2]<<endl;

  (*bodyfile)<<"# J\n"
	     <<JT[0][0]<<" "<<JT[0][1]<<" "<<JT[0][2]<<" "<<endl
	     <<JT[1][0]<<" "<<JT[1][1]<<" "<<JT[1][2]<<" "<<endl
	     <<JT[2][0]<<" "<<JT[2][1]<<" "<<JT[2][2]<<" "<<endl;

  (*bodyfile)<<"# NodeCoordinates\n";
  for(int i=0;i<nNodes;i++) 
	     (*bodyfile) << NC[i].r << " " << NC[i].j << endl;
  (*bodyfile)<<"# ElementNodeList\n";
  for(int i=0;i<nElements;i++) 
	     (*bodyfile) << ENL[i].node0 <<" "<< ENL[i].node1 <<" "<< ENL[i].node2 <<" "<< ENL[i].node3 << endl;
}
