/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef ELASTICBODY2S13DISK_H
#define ELASTICBODY2S13DISK_H

#include <elastic.h>

namespace AMVis {

  struct NodeCoordinates {float r; float j;};
  struct ElementNodeList {int node0;int node1;int node2;int node3;};
  //! 
  class ElasticBody2s13Disk : public ElasticBody {

    public:
      ElasticBody2s13Disk(const std::string &base, int nr_, int nj_, int num, bool bin);
      ElasticBody2s13Disk();

      /*! Set the Jacobian for translations and rotations.  */
      void setJacobian(float J_[3][3]);

      /*! set element lenght */
      void setRadii(float Ri_, float Ra_);

      /*! Elects the cylinder contour of a FE-Beam (Priority 1) */
      void setThickness(float di_[3], float da_[3]);

      /*! set node topology */
      void setNodeCoordinates(NodeCoordinates NC_[]);
      /*! set element-node association */
      void setElementNodeList(ElementNodeList ENL_[]);

      void writeBodyFile() const;

    protected:
      float JT[3][3];

      /** number of radial */
      int nr;
      /** number of azimutal */
      int nj;
      /** number of elements */
      int nElements;
      /** number of nodes */
      int nNodes;
      /** topology of nodes */
      NodeCoordinates *NC;
      /** association of nodes th elements */
      ElementNodeList *ENL;

      /** outer radius */
      float Ra;
      /** inner radius */
      float Ri;

      /** inner thickness */
      float di[3];
      /** outer thickness */
      float da[3];

      void writeToBodyFile(std::ofstream *bodyfile) const;

  };

}

#endif
