/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <extrusion.h>

using namespace AMVis;
using namespace std;

Extrusion::Extrusion(const string &base, int num, bool bin, bool destroyMem_) : destroyMem(destroyMem_), CRigidBody(base, num, bin) {
  className="Extrusion";
  windingRule="ODD";
  height=0.1;
}

Extrusion::Extrusion(bool destroyMem_) : destroyMem(destroyMem_), CRigidBody() {
  className="Extrusion";
  windingRule="ODD";
  height=0.1;
}

Extrusion::~Extrusion() {
  clearContours();
}

void Extrusion::setWindingRule(const string &rule) {
  windingRule=rule;
}

void Extrusion::setHeight(float h) {
  height=h;
}

void Extrusion::clearContours() {
  if(destroyMem) {
    vector<vector<PolygonPoint*>*>::iterator i;
    vector<PolygonPoint*>::iterator j;
    for(i=contours.begin(); i!=contours.end(); i++) {
      for(j=(*i)->begin(); j!=(*i)->end(); j++)
        delete *j; *j=NULL;
      (*i)->clear();
      delete *i; *i=NULL;
    }
  }
  contours.clear();
}

void Extrusion::addContour(vector<PolygonPoint*> *cont) {
  contours.push_back(cont);
}

void Extrusion::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Extrusion::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# OpenGL winding rule (ODD, NONZERO, POSITIVE, NEGATIVE, ABS_GEQ_TWO)"<<endl;
  (*bodyfile)<<windingRule<<endl;
  (*bodyfile)<<"# extursion height"<<endl;
  (*bodyfile)<<height<<endl;
  (*bodyfile)<<"# polygon contour definition (x y border)"<<endl;
  (*bodyfile)<<"# border=0: this polygon edge should be rendered smooth"<<endl;
  (*bodyfile)<<"# border=1: this polygon edge should be rendered none smooth"<<endl;
  (*bodyfile)<<"# border=-2: a new polygon contour will follow (x, y: irrelevant)"<<endl;
  (*bodyfile)<<"# border=-1: all polygon definitions are finished (x, y: irrelevant)"<<endl;
  vector<vector<PolygonPoint*>*>::const_iterator i;
  vector<PolygonPoint*>::const_iterator j;
  for(i=contours.begin(); i!=contours.end(); i++) {
    if (i!=contours.begin()) (*bodyfile)<<"0 0 -2"<<endl;
    for(j=(*i)->begin(); j!=(*i)->end(); j++) {
      (*bodyfile)<<(*j)->x<<" "<<(*j)->y<<" "<<(*j)->b<<endl;
    }
  }
  (*bodyfile)<<"0 0 -1"<<endl;
}
