/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <kos.h>

using namespace AMVis;
using namespace std;

Kos::Kos(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="Kos";
  size=0.05;
  offset=0;
}

Kos::Kos() : CRigidBody() {
  className="Kos";
  size=0.05;
}

void Kos::setSize(float size_) {
  size=size_;
}

void Kos::setOffset(float offset_) {
  offset=offset_;
}

void Kos::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Kos::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# size of the Kos"<<endl;
  (*bodyfile)<<size<<endl;
  (*bodyfile)<<"# offset of the Kos"<<endl;
  (*bodyfile)<<offset<<endl;
}
