/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <cmath>
#include <objobject.h>

using namespace AMVis;
using namespace std;

ObjObject::ObjObject(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="ObjObject";
  objFilename="";
  useTex=true;
  useMat=true;
  normalFlag=0;
  epsVertex=-1;
  epsNormal=-1;
  epsAngle=20*M_PI/180;
  outlineFlag=1;
}

ObjObject::ObjObject() : CRigidBody() {
  className="ObjObject";
  objFilename="";
  useTex=true;
  useMat=true;
  normalFlag=0;
  epsVertex=-1;
  epsNormal=-1;
  epsAngle=20*M_PI/180;
  outlineFlag=1;
}

void ObjObject::setObjFilename(const string &filename) {
  objFilename=filename;
}

void ObjObject::setUseTextures(bool use) {
  useTex=use;
}

void ObjObject::setUseMaterials(bool use) {
  useMat=use;
}

void ObjObject::setCalculationOfNormals(int flag) {
  normalFlag=flag;
}

void ObjObject::setVertexEPS(float eps) {
  epsVertex=eps;
}

void ObjObject::setNormalEPS(float eps) {
  epsNormal=eps;
}

void ObjObject::setAngleEPS(float eps) {
  epsAngle=eps;
}

void ObjObject::setOutline(int outline) {
  outlineFlag=outline;
}

void ObjObject::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void ObjObject::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);

  (*bodyfile)<<"# filename of the wavefront file"<<endl;
  (*bodyfile)<<objFilename<<endl;
  (*bodyfile)<<"# use textures from material library (1=use textures, 0=do not use textures)"<<endl;
  (*bodyfile)<<useTex<<endl;
  (*bodyfile)<<"# use materials from material library (1=use materials, 0=do not use materials)"<<endl;
  (*bodyfile)<<useMat<<endl;
  (*bodyfile)<<"# calculation of face normals:"<<endl;
  (*bodyfile)<<"# 0=use normals from obj-file"<<endl;
  (*bodyfile)<<"# 1=calculate per face normals (flat shading)"<<endl;
  (*bodyfile)<<"# 2=calculate per vertex normals (smooth shading; average of all adjacent normals)"<<endl;
  (*bodyfile)<<"# 3=calculate real normals (smooth, if angle is small; flat, if angle is great)"<<endl;
  (*bodyfile)<<normalFlag<<endl;
  (*bodyfile)<<"# eps-value when vertices are to be treated as equal"<<endl;
  (*bodyfile)<<"# netative value = no vertices combination"<<endl;
  (*bodyfile)<<"# (Is only used for outline calculation and calculation of face normals=2,3)"<<endl;
  (*bodyfile)<<epsVertex<<endl;
  (*bodyfile)<<"# eps-value when normals are to be treated as equal"<<endl;
  (*bodyfile)<<"# netative value = no normals combination"<<endl;
  (*bodyfile)<<"# (Is only used for outline calculation)"<<endl;
  (*bodyfile)<<epsNormal<<endl;
  (*bodyfile)<<"# eps-value when faces are to be treated as smooth"<<endl;
  (*bodyfile)<<"# (Is only used for real nomral calculation and outline calculation)"<<endl;
  (*bodyfile)<<epsAngle<<endl;
  (*bodyfile)<<"# calculation of outlines:"<<endl;
  (*bodyfile)<<"# 0=no outline calculation is done"<<endl;
  (*bodyfile)<<"# 1=calculate outline"<<endl;
  (*bodyfile)<<"# 2=read outline from file objfile.outline.obj"<<endl;
  (*bodyfile)<<outlineFlag<<endl;
}
