/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <path.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

Path::Path(const string &base, int num, bool bin) : CBody(base, num, bin) {
  className="Path";
  r=0;
  g=1;
  b=1;
}

void Path::setColor(float r_, float g_, float b_) {
  r=r_;
  g=g_;
  b=b_;
}

void Path::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Path::writeToBodyFile(ofstream *bodyfile) const {
  CBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<r<<" "<<g<<" "<<b<<endl;
}

void Path::appendDataset(int ind) const {
  if(binaryPosFile==false) {
    posfile[ind]<<setw(AMVIS_FLOAT_WIDTH)<<t<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<x<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<y<<" "
                <<setw(AMVIS_FLOAT_WIDTH)<<z<<endl;
  }
  else {
    posfile[ind].write((char*)&t, sizeof(float));
    posfile[ind].write((char*)&x, sizeof(float));
    posfile[ind].write((char*)&y, sizeof(float));
    posfile[ind].write((char*)&z, sizeof(float));
  }
  if(flush) posfile[ind].flush();
}

void Path::setTime(float time) {
  t=time;
}

void Path::setPoint(float x_, float y_, float z_) {
  x=x_;
  y=y_;
  z=z_;
}
