/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef PATH_H
#define PATH_H

#include <cbody.h>

namespace AMVis {

  //! Creates a path.
  /*!
   * This class is used to create a path.
   */
  class Path : public CBody {
    public:
      //! Create a Path.
      /*!
       * Draws a polyline in space from t_0 to t_currentdataset.
       * baseFilename is the basename of the body and pos file. instances is the
       * number of instances this body should create and if binPosFile is true the
       * pos file is created in binary mode or in ascii mode if false.
       */
      Path(const std::string &, int, bool);

      //! Set the color of th path.
      /*!
       * r: red; g: green; b: blue.
       */
      void setColor(float r, float g, float b);

      //! Write a path body file.
      virtual void writeBodyFile() const;

      //! Append a dataset to the pos file.
      /*!
       * Appends the current dataset (set with AMVis::Path::setTime,
       * AMVis::Path::setPoint to the pos file with index ind.
       * ind runs from 0 to instances-1.
       */
      virtual void appendDataset(int ind) const;

      //! Set the current simulation time.
      void setTime(float time);

      //! Set point.
      /*!
       * x, y and z are the world coordinates of the point of the path.
       */
      void setPoint(float x, float y, float z);

    protected:
      float r, g, b;

      float t, x, y, z;

      void writeToBodyFile(std::ofstream *) const;
  };

}

#endif
