/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <rotation.h>

using namespace AMVis;
using namespace std;

Rotation::Rotation(const string &base, int num, bool bin, bool destroyMem_) : contour(0), destroyMem(destroyMem_), CRigidBody(base, num, bin) {
  className="Rotation";
}

Rotation::Rotation(bool destroyMem_) : contour(0), destroyMem(destroyMem_),  CRigidBody() {
  className="Rotation";
}

Rotation::~Rotation() {
  clearContour();
}

void Rotation::clearContour() {
  if(contour && destroyMem) {
    vector<PolygonPoint*>::iterator i;
    for(i=contour->begin(); i!=contour->end(); i++)
      delete *i; *i=NULL;
    contour->clear();
    delete contour; contour=NULL;
    contour=0;
  }
}

void Rotation::setContour(vector<PolygonPoint*> *cont) {
  clearContour();
  contour=cont;
}

void Rotation::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Rotation::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# polygon contour definition (x y border)"<<endl;
  (*bodyfile)<<"# border=0: this polygon edge should be rendered smooth"<<endl;
  (*bodyfile)<<"# border=1: this polygon edge should be rendered none smooth"<<endl;
  (*bodyfile)<<"# border=-1: polygon definition is finished (x, y: irrelevant)"<<endl;
  vector<PolygonPoint*>::iterator j;
  for(j=contour->begin(); j!=contour->end(); j++) {
    (*bodyfile)<<(*j)->x<<" "<<(*j)->y<<" "<<(*j)->b<<endl;
  }
  (*bodyfile)<<"0 0 -1"<<endl;
}
