/*
    AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
                        Used by AMVis
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <config.h>
#include <torus.h>

using namespace AMVis;
using namespace std;

Torus::Torus(const string &base, int num, bool bin) : CRigidBody(base, num, bin) {
  className="Torus";
  innerRadius=0.01;
  outerRadius=0.03;
}

Torus::Torus() : CRigidBody() {
  className="Torus";
  innerRadius=0.01;
  outerRadius=0.03;
}

void Torus::setInnerRadius(float rad) {
  innerRadius=rad;
}

void Torus::setOuterRadius(float rad) {
  outerRadius=rad;
}

void Torus::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void Torus::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# radius of the tube (inner-radius)"<<endl;
  (*bodyfile)<<innerRadius<<endl;
  (*bodyfile)<<"# radius of axis of the tube (outer-radius)"<<endl;
  (*bodyfile)<<outerRadius<<endl;
}
