/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <vt_rockerarm.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

VT_RockerArm::VT_RockerArm(const string &base, int num, bool bin) : CRigidBody(base, num, bin), Ax(0), Ay(0), Ra(0), alpha0(0), alpha(0), Cx(0), Cy(0), Rc(0), gamma(0), gamma0(0), Dx(0), Dy(0), Rd(0), delta0(0), delta(0), r(0), width(0), FlagSideFrame(0){
  className="VT_RockerArm";
}

VT_RockerArm::VT_RockerArm() : CRigidBody(), Ax(0), Ay(0), Ra(0), alpha0(0), alpha(0), Cx(0), Cy(0), Rc(0), gamma(0), gamma0(0), Dx(0), Dy(0), Rd(0), delta0(0), delta(0), r(0), width(0), FlagSideFrame(0){
  className="VT_RockerArm";
}

void VT_RockerArm::setContactValve(float Ax_, float Ay_, float Ra_, float alpha0_, float alpha_) {
  Ax = Ax_;
  Ay = Ay_;
  Ra = Ra_;
  alpha0 = alpha0_;
  alpha  = alpha_;
}

void VT_RockerArm::setContactHLA(float x_, float y_, float r_, float gamma0_, float gamma_) {
  Cx = x_;
  Cy = y_;
  Rc = r_;
  gamma0 = gamma0_;
  gamma  = gamma_;
  Rd =0.0;
  delta =0.0;
}

void VT_RockerArm::setContactHLA_C(float Cx_, float Cy_, float Rc_, float gamma0_, float gamma_) {
  Cx = Cx_;
  Cy = Cy_;
  Rc = Rc_;
  gamma0 = gamma0_;
  gamma  = gamma_;
}

void VT_RockerArm::setContactHLA_D(float Dx_, float Dy_, float Rd_, float delta0_, float delta_) {
  Dx = Dx_;
  Dy = Dy_;
  Rd = Rd_;
  delta  = delta_;
  delta0 = delta0_;
}

void VT_RockerArm::setRadiusBearing(float r_) {
  r = r_;
}

void VT_RockerArm::setWidth(float w_){
  width = w_;
}

void VT_RockerArm::setFlagSideFrame(int Flag) {
  FlagSideFrame = Flag;
  if (FlagSideFrame<0) FlagSideFrame =0;
  if (FlagSideFrame>3) FlagSideFrame =3;
}

void VT_RockerArm::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void VT_RockerArm::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# Point A: center of contact radius with valve. [Ax Ay]T"<<endl;
  (*bodyfile)<<Ax<<" "<<Ay<< endl;
  (*bodyfile)<<"# Ra: radius of valve contact"<<endl;
  (*bodyfile)<<Ra<<endl;
  (*bodyfile)<<"# start and length of valve contact (in degree). [alpha0 alpha]T"<<endl;
  (*bodyfile)<<alpha0<<" "<<alpha<<endl;
  (*bodyfile)<<"# Point C: center of 1st contact radius with HLA. [Cx Cy]T"<<endl;
  (*bodyfile)<<Cx<<" "<<Cy<< endl;
  (*bodyfile)<<"# Rc: radius of 1st HLA contact"<<endl;
  (*bodyfile)<<Rc<<endl;
  (*bodyfile)<<"# start and length of 1st HLA contact (in degree). [gamma0 gamma]T"<<endl;
  (*bodyfile)<<gamma0<<" "<<gamma<<endl;
  (*bodyfile)<<"# Point D: center of 2nd contact radius with HLA. [Dx Dy]T"<<endl;
  (*bodyfile)<<Dx<<" "<<Dy<< endl;
  (*bodyfile)<<"# Rd: radius of 2nd HLA contact"<<endl;
  (*bodyfile)<<Rd<<endl;
  (*bodyfile)<<"# start and length of 2nd HLA contact (in degree). [delta0 delta]T"<<endl;
  (*bodyfile)<<delta0<<" "<<delta<<endl;
  (*bodyfile)<<"# r:  radius roller bearing"<<endl;
  (*bodyfile)<<r<<endl;
  (*bodyfile)<<"# width of rocker arm"<<endl;
  (*bodyfile)<<width<<endl;
  (*bodyfile)<<"# FlagSideFrame: 0: no side frame;  1,2: side frame  pos./neg. direction; 3: both side frames are drawn"<<endl;
  (*bodyfile)<<FlagSideFrame<<endl;
}
