/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ROCKERARM_H
#define ROCKERARM_H

#include <crigidbody.h>

namespace AMVis {

  //! Creates a rocker for valve train visualisation.
  /*!
   * This class is used to create a rocker arm   */
  class VT_RockerArm : public CRigidBody {
    public:
      //! Create a rocker arm
      /*!
       * baseFilename is the basename of the body and pos file. instances is the
       * number of instances this body should create and if binPosFile is true the
       * pos file is created in binary mode or in ascii mode if false.
       */
      VT_RockerArm(const std::string &, int, bool);
      VT_RockerArm();
      
      //! Set Contact Geometrie valve contact (center [xA, yA], radius rA and arclenght from alpha0 to alpha0+alpha).
      void setContactValve(float Ax_, float Ay_, float Ra_, float alpha0_, float alpha_);

      //! Set Contact Geometrie HLA contact  (center [x, y], radius rC and arclenght from ga0 to ga0+ga, Rd is set to zero).
      void setContactHLA(float x_, float y_, float r_, float gamma0_, float gamma_);

      //! Set single Contact Geometrie HLA contact (center [xC, yC], radius rC and arclenght from gamma0 to gamam0+gamma).
      void setContactHLA_C(float Cx_, float Cy_, float Rc_, float gamma0_, float gamma_);

      //! Set single Contact Geometrie HLA contact (center [xD, yD], radius rD and arclenght from delta0 to delta0+delta).
      void setContactHLA_D(float Dx_, float Dy_, float Rd_, float delta0_, float delta_);

      //! Set Radius roller bearing
      void setRadiusBearing(float r_);

      //! Set Width
      void setWidth(float w_);

      //! Choose which side frames are displayed.
      /*!
       * 0: no side frame;    1,2: one side frame pos, neg direction;     3: both side frames 
       */
      void setFlagSideFrame(int Flag);
       
      //! Write a body file.
      virtual void writeBodyFile() const;

    protected:
      int FlagSideFrame;
      float Ax, Ay, Ra, alpha0, alpha, Cx, Cy, Rc, gamma0, gamma, Dx, Dy, Rd, delta0, delta, r, width;

      void writeToBodyFile(std::ofstream *) const;
  };

}

#endif


