/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#include <config.h>
#include <vt_valve.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

VT_Valve::VT_Valve(const string &base, int num, bool bin) : CRigidBody(base, num, bin), r(0), R(0), Rsk(0), Rsg(0), h(0), Lsg(0), Lsk(0){
  className="VT_Valve";
}
VT_Valve::VT_Valve() : CRigidBody(), r(0), R(0), Rsk(0), Rsg(0), h(0), Lsg(0), Lsk(0){
  className="VT_Valve";
}

void VT_Valve::setAllRadii(float r_, float R_, float Rsk_, float Rsg_, bool reorder) {
  if (reorder) {
    int n=4;
    float Liste[n];
    Liste[0] = r_;
    Liste[1] = R_;
    Liste[2] = Rsk_;
    Liste[3] = Rsg_;
    // sortieren der Liste
    for(int i=0; i<n-1; i++) {
      for(int j=1; j<(n-i); j++) {
	if (Liste[j] < Liste[j-1]) { 
	  double tmp=Liste[j];
	  Liste[j] = Liste[j-1];
	  Liste[j-1]= tmp;
	}
      }
    }
    r   = Liste[0];
    R   = Liste[1];
    Rsk = Liste[2];
    Rsg = Liste[3];
  }
  r  = r_;
  R  = R_;
  Rsk= Rsk_;
  Rsg= Rsg_;
}

void VT_Valve::setAllLength(float h_, float Lsk_, float Lsg_, bool reorder) {
  if (reorder) {
    int n=3;
    float Liste[n];
    Liste[0] = h_;
    Liste[1] = Lsk_;
    Liste[2] = Lsg_;
    // sortieren der Liste
    for(int i=0; i<n-1; i++) {
      for(int j=1; j<(n-i); j++) {
	if (Liste[j] < Liste[j-1]) { 
	  double tmp=Liste[j];
	  Liste[j] = Liste[j-1];
	  Liste[j-1]= tmp;
	}
      }
    }
    h   = Liste[0];
    Lsk = Liste[1];
    Lsg = Liste[2];
  }
  h  = h_;
  Lsk= Lsk_;
  Lsg= Lsg_;
}


void VT_Valve::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}


void VT_Valve::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# radius r valve shank"<<endl;
  (*bodyfile)<<r<<endl;
  (*bodyfile)<<"# distance h valve top to bottom side of disc"<<endl;
  (*bodyfile)<<h<<endl;
  (*bodyfile)<<"# radius R valve disc"<<endl;
  (*bodyfile)<<R<<endl;
  (*bodyfile)<<"# inner radius valve (bottom)"<<endl;
  (*bodyfile)<<Rsk<<endl;
  (*bodyfile)<<"# outer radius valve (bottom)"<<endl;
  (*bodyfile)<<Rsg<<endl;
  (*bodyfile)<<"# distance valve top to uper surface of valve"<<endl;
  (*bodyfile)<<Lsk<<endl;
  (*bodyfile)<<"# length valve"<<endl;
  (*bodyfile)<<Lsg<< endl;
}
