/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef VALVE_H
#define VALVE_H

#include <crigidbody.h>

namespace AMVis {

  //! Creates a valve for valve train visualisation.
  /*!
   * This class is used to create a valve   */
  class VT_Valve : public CRigidBody {
    public:
      //! Create a Valve
      /*!
       * baseFilename is the basename of the body and pos file. instances is the
       * number of instances this body should create and if binPosFile is true the
       * pos file is created in binary mode or in ascii mode if false.
       */
      VT_Valve(const std::string &, int, bool);
      VT_Valve();

      //! set radius valve shank 
      void setr(float r_) 	{r  = r_;}
      //! set radius valve disk
      void setR(float R_) 	{R  = R_;}
      //! set inner radius bottom valve
      void setRsk(float Rsk_)   {Rsk= Rsk_;}
      //! set outer radius bottom valve
      void setRsg(float Rsg_)   {Rsg= Rsg_;}
      //! set distance valve top to valve disk (bootom side)
      void seth(float h_)       {h  = h_;}
      //! set distance valve top to uper surface valve
      void setLsk(float Lsk_)   {Lsk= Lsk_;}
      //! set overall lenght of valve
      void setLsg(float Lsg_)   {Lsg= Lsg_;}
      /*! set all radii; reorder=true: parameters are reordered before assignment
       *  (smallest value is assigned to r, biggest to Rsg) 
       */
      void setAllRadii(float r_, float R_, float Rsk_, float Rsg_, bool reorder=true); 
      //! set all length; reorder= true: parameters are reordered before assignment
      void setAllLength(float h_, float Lsk_, float Lsg_, bool reorder=true);

      //! Write a body file.
      virtual void writeBodyFile() const;

    protected:
      float r, R, Rsk, Rsg, h, Lsg, Lsk;

      void writeToBodyFile(std::ofstream *) const;
  };

}

#endif
