/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#include <config.h>
#include <vt_valveseat.h>
#include <iomanip>

using namespace AMVis;
using namespace std;

VT_ValveSeat::VT_ValveSeat(const string &base, int num, bool bin) : CRigidBody(base, num, bin),R(0), Rsk(0), Rsg(0), h(0), l(0){
  className="VT_ValveSeat";
}

VT_ValveSeat::VT_ValveSeat() : CRigidBody(), R(0), Rsk(0), Rsg(0), h(0), l(0){
  className="VT_ValveSeat";
}

void VT_ValveSeat::setAllRadii(float R1, float R2, float R3) {
  int n=3;
  float Liste[n];
  Liste[0] = R1;
  Liste[1] = R2;
  Liste[2] = R3;
  // sortieren der Liste
  for(int i=0; i<n-1; i++) {
    for(int j=1; j<(n-i); j++) {
      if (Liste[j] < Liste[j-1]) { 
	double tmp=Liste[j];
	Liste[j] = Liste[j-1];
	Liste[j-1]= tmp;
      }
    }
  }
  Rsk   = Liste[0];
  Rsg   = Liste[1];
  R     = Liste[2];
}

void VT_ValveSeat::setAllLength(float l1, float l2) {
  if (l1<l2) {
    l= l1;
    h= l2;
  }
  else {
    l= l2;
    h= l1;
  }
}

void VT_ValveSeat::writeBodyFile() const {
  ofstream *bodyfile=openBodyFile();
  writeToBodyFile(bodyfile);
  closeBodyFile(bodyfile);
}

void VT_ValveSeat::writeToBodyFile(ofstream *bodyfile) const {
  CRigidBody::writeToBodyFile(bodyfile);
  (*bodyfile)<<"# Rsk: inner radius"<<endl;
  (*bodyfile)<<Rsk<<endl;
  (*bodyfile)<<"# Rsg: radius end of phase"<<endl;
  (*bodyfile)<<Rsg<<endl;
  (*bodyfile)<<"# l: distance bottom begin phase"<<endl;
  (*bodyfile)<<l<<endl;
  (*bodyfile)<<"# h: length"<<endl;
  (*bodyfile)<<h<<endl;
  (*bodyfile)<<"# R: Radius (outer surface)"<<endl;
  (*bodyfile)<<R<<endl;
}
