/*
   AMVisC++Interface - C++ Interface for Body- and Pos-File Creation
   Used by AMVis
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technical University of Munich

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   */

#ifndef VALVESEAT_H
#define VALVESEAT_H

#include <crigidbody.h>

namespace AMVis {

  //! Creates a valve seat for valve train visualisation.
  /*!
   * This class is used to create a valve seat  */
  class VT_ValveSeat : public CRigidBody {
    public:
      //! Create a Valve Seat
      /*!
       * baseFilename is the basename of the body and pos file. instances is the
       * number of instances this body should create and if binPosFile is true the
       * pos file is created in binary mode or in ascii mode if false.
       */
      VT_ValveSeat(const std::string &, int, bool);
      VT_ValveSeat();

      //! set inner radius  
      void setRsk(float Rsk_) 	{Rsk= Rsk_;}
      //! set radius end of phase
      void setRsg(float Rsg_) 	{Rsg= Rsg_;}
      //! set outer radius
      void setR(float R_)       {R  = R_;}
      //! set length 
      void seth(float h_)       {h  = h_;}
      //! set lenght to phase   
      void setl(float l_)       {l  = l_;}
      //! set all radii; parameters are reordered before assignment (Rsk (smallest), Rsg, R(biggest)) 
      void setAllRadii(float R1, float R2, float R3); 
      //! set all length; parameters are reordered before assignment (l(smallest), h(biggest)
      void setAllLength(float l1, float l2);

      //! Write a body file.
      virtual void writeBodyFile() const;

    protected:
      float R, Rsk, Rsg, h, l;

      void writeToBodyFile(std::ofstream *) const;
  };

}

#endif
