function AMVisArrow(name,instances,diameter,diameterhead,length,type,scale)
% Usage: AMVisArrow(name,instances,diameter,diameterhead,length,type)
%   name:         Name of the body-file (without .body)
%   instances:    Number of instances of pos-files
%                 Writes a bodyenv if zero or negativ
%   diameter:     Diameter of the arrow body
%   diameterhead: Diameter of the arrowhead
%   length:       Length of the arrowhead
%   type:         Type of the arrow
%                 0: no head
%                 1: only a to head
%                 2: only a from head
%                 3: both heads
%   scale:        Scale factor of the arrow length

  file=AMVisCBody(name,'Arrow',instances);
  fprintf(file, '%13.5e\n', diameter);
  fprintf(file, '%13.5e\n', diameterhead);
  fprintf(file, '%13.5e\n', length);
  fprintf(file, '%d\n', type);
  fprintf(file, '%13.5e\n', scale);
  fclose(file);
