function AMVisExtrusion(name,instances,inittrans,initrot,scale,windingrule,height,varargin)
% Usage: AMVisExtrusion(name,instances,inittrans,initrot,scale,windingrule,
%                       height,contour,...)
%   name:        Name of the body-file (without .body)
%   instances:   Number of instances of pos-files
%                Writes a bodyenv if zero or negativ
%   inittrans:   Initial translation [x y z]
%   initrot:     Initial rotation [alpha beta gamma]
%   scale:       Scale factor
%   windingrule: OpenGL winding rule
%                (ODD, NONZERO, POSITIVE, NEGATIVE, ABS_GEQ_TWO)
%   height:      Height of the extrusion
%   contour:     Contour points [x y edge]; x,y,edge: Vectors of size N x 1
%   ...:         More contours

  file=AMVisCRigidBody(name,'Extrusion',instances,inittrans,initrot,scale);
  fprintf(file, '%s\n', windingrule);
  fprintf(file, '%13.5e\n', height);
  for i=8-7:nargin-7
    fprintf(file, '%13.5e %13.5e %d\n', varargin{i}');
    fprintf(file, '0 0 -2\n');
  end
  fprintf(file, '0 0 -1\n');
  fclose(file);
