function AMVisObjObject(name,instances,inittrans,initrot,scale,objfilename,usetex,usemat,normalcal,verteps,normaleps,angleeps,outline)
% Usage: AMVisObjObject(name,instances,inittrans,initrot,scale,objfilename,
%                       usetex,usemat,normalcal,verteps,normaleps,angleeps,
%                       outline)
%   name:        Name of the body-file (without .body)
%   instances:   Number of instances of pos-files
%                Writes a bodyenv if zero or negativ
%   inittrans:   Initial translation [x y z]
%   initrot:     Initial rotation [alpha beta gamma]
%   scale:       Scale factor
%   objfilename: Filename of the wavefront file
%   usetex:      Use textures from material library
%                (1=use textures, 0=do not use textures)
%   usemat:      Use materials from material library
%                (1=use materials, 0=do not use materials)
%   normalcal:   Calculation of face normals:
%                0=use normals from obj-file
%                1=calculate per face normals (flat shading)
%                2=calculate per vertex normals (smooth shading; average of
%                  all adjacent normals)
%                3=calculate real normals (smooth, if angle is small; flat,
%                  if angle is great)
%   verteps:     eps-value when vertices are to be treated as equal
%                netative value = no vertices combination
%                (Only for outline calculation and real (3) face normal
%                calculation used)
%   normaleps:   eps-value when normals are to be treated as equal
%                netative value = no normals combination
%                (Only for outline calculation used)
%   angleeps:    eps-value when faces are to be treated as smooth
%   outline:     calculation of outlines:
%                0=no outline calculation is done
%                1=calculate outline
%                2=read outline from file objfile.outline.obj

  file=AMVisCRigidBody(name,'ObjObject',instances,inittrans,initrot,scale);
  fprintf(file, '%s\n', objfilename);
  fprintf(file, '%d\n', usetex);
  fprintf(file, '%d\n', usemat);
  fprintf(file, '%d\n', normalcal);
  fprintf(file, '%13.5e\n', verteps);
  fprintf(file, '%13.5e\n', normaleps);
  fprintf(file, '%13.5e\n', angleeps);
  fprintf(file, '%d\n', outline);
  fclose(file);
