function createObjFace(filename, X, Y, A, ori)
% Usage: createObjFace(filename, X, Y, A, ori)
% create a obj file = surf(X, Y, A)
% ori=0: Dreiecksflaechen linksoben, rechtsunten (default)
% ori=1: Dreiecksflaechen linksunten, rechtsoben

if !exist('ori', 'var')
  ori=0;
end

f=fopen(filename, 'w');

lengthX=length(X);

for r=1:length(Y)
  for c=1:length(X)
    fprintf(f, 'v %e %e %e\n', X(c), Y(r), A(r,c));
  end
end

for r=1:length(Y)-1
  for c=1:length(X)-1
    if ori==0
      fprintf(f, 'f %d %d %d\n', (r-1)*lengthX+c, r*lengthX+c, r*lengthX+c+1);
      fprintf(f, 'f %d %d %d\n', (r-1)*lengthX+c, r*lengthX+c+1, (r-1)*lengthX+c+1);
    else
      fprintf(f, 'f %d %d %d\n', (r-1)*lengthX+c, r*lengthX+c, (r-1)*lengthX+c+1);
      fprintf(f, 'f %d %d %d\n', r*lengthX+c, r*lengthX+c+1, (r-1)*lengthX+c+1);
    end
  end
end

fclose(f);
