#include <iostream>
#include <fstream>

using namespace std;

// KETSIM AMVis data structure
struct Data {
  float t, x, y, z, gamma, color;
};

// main program
int main(int argc, char *argv[]) {
  // parameters
  if(argc!=5) {
    cout<<"Usage: "<<argv[0]<<" <scale> <pre> <dir>"<<endl;
    cout<<"  <refDatesetNr>: Dataset # for reference angle"<<endl;
    cout<<"  <scale>:        Scale factor for angle"<<endl;
    cout<<"  <pre>:          Body filename without extension"<<endl;
    cout<<"  <dir>:          Working directory"<<endl;
    return 0;
  }
  int refDatasetNr;
  char *dir;
  double scale;
  char *pre;
  refDatasetNr=atoi(argv[1]);
  scale=atof(argv[2]);
  pre=argv[3];
  dir=argv[4];




  char c1[10000];
  strcpy(c1, dir);
  strcat(c1, "/");
  strcat(c1, pre);
  strcat(c1, ".0001.pos");
  ifstream file(c1);

  Data data;
  file.seekg(refDatasetNr*sizeof(Data), ios::beg);
  file.read((char*)(&data), sizeof(Data));
  double gamma0=data.gamma;
  file.seekg(0, ios::beg);

  strcat(c1, ".out");
  ofstream fileOut(c1);
  while(file.read((char*)(&data), sizeof(Data))) {
    data.gamma=(data.gamma-gamma0)*scale;
    fileOut.write((char*)(&data), sizeof(Data));
  }
  file.close();
  fileOut.close();




  return 0;
}
