#include <nurbs++/vector.h>
#include <nurbs++/nurbs.h>
#include <vector>

using namespace PLib;
using namespace std;

// KETSIM AMVis data structure
struct Data {
  float t, x, y, z, gamma, color;
};

// create full file name
void filename(int k, char *dir, char *pre[2], char *name) {
  int i=(k+1)/2;
  int j=(k-1)%2;
  char c1[10000];
  char c2[10000];
  strcpy(c1, dir);
  strcat(c1, "/");
  strcat(c1, pre[j]);
  strcat(c1, ".");
  sprintf(c2, "%04d", i);
  strcat(c1, c2);
  strcat(c1, ".pos");
  strcpy(name, c1);
}

// read one Gl and scale normals
vector<Data> readAndScale(int k, char *dir, char *pre[2], const NurbsCurve<double,2>& curve, double scale, int N) {
  char c1[10000];
  filename(k, dir, pre, c1);
  ifstream pos(c1);

  // get good guess value for NURBS parameter
  Data data;
  double p;
  double min=1e6;
  pos.read((char*)(&data), 6*sizeof(float));
  Point_nD<double,2> pt(data.x,data.y), ptProject;
  double pOut;
  for(double pIn=0; pIn<1; pIn+=1.0/2/N) {
    curve.projectTo(pt, pIn, pOut, ptProject,1e-7,1e-7,1000);
    double dist=(ptProject.x()-pt.x())*(ptProject.x()-pt.x())+
                (ptProject.y()-pt.y())*(ptProject.y()-pt.y());
    if(dist<min) {
      min=dist;
      p=pOut;
    }
  }
  pos.seekg(0, ios_base::beg);

  // scale normals
  vector<Data> ret;
  while(pos.read((char*)(&data), 6*sizeof(float))) {
    Point_nD<double,2> pt(data.x,data.y), ptProject;
    curve.projectTo(pt, p, p, ptProject,1e-7,1e-7,1000);
    // check for to low p
    if(p<0) {
      p=p+1;
      curve.projectTo(pt, p, p, ptProject,1e-7,1e-7,1000);
    }
    // check for to high p
    if(p>1) {
      p=p-1;
      curve.projectTo(pt, p, p, ptProject,1e-7,1e-7,1000);
    }
    data.x=(data.x-ptProject.x())*scale+ptProject.x();
    data.y=(data.y-ptProject.y())*scale+ptProject.y();
    ret.push_back(data);
  }
  pos.close();
  return ret;
}

// reset new angle for Gl
void angle(vector<Data>& dataL, const vector<Data>& data) {
  for(int i=0; i<dataL.size(); i++)
    dataL[i].gamma=atan2(data[i].y-dataL[i].y,data[i].x-dataL[i].x);
}

// write new Gl data
void write(int k, char *dir, char *pre[2], const vector<Data>& dataL) {
  char c1[10000];
  filename(k, dir, pre, c1);
  strcat(c1, ".out");
  ofstream pos(c1);
  for(int i=0; i<dataL.size(); i++)
    pos.write((char*)(&dataL[i]), 6*sizeof(float));
  pos.close();
}

// main program
int main(int argc, char *argv[]) {
  // parameters
  if(argc!=8) {
    cout<<"Usage: "<<argv[0]<<" <degree> <kPoints> <refDatasetNr> <scale> <pre0> <pre1> <dir>"<<endl;
    cout<<"  <degree>:       Polynom degree of NURBS"<<endl;
    cout<<"  <kPoints>:      # NURBS control points = <kPoints> * # Gl"<<endl;
    cout<<"  <refDatesetNr>: Dataset # for reference trajectory"<<endl;
    cout<<"  <scale>:        Scale factor for normals"<<endl;
    cout<<"  <pre0>:         Body filename without extension (first)"<<endl;
    cout<<"  <pre1>:         Body filename without extension (second)"<<endl;
    cout<<"  <dir>:          Working directory"<<endl;
    return 0;
  }
  char *dir;
  int degree;
  double scale;
  int refDatasetNr;
  double kPoints;
  char *pre[2];
  degree=atoi(argv[1]);
  kPoints=atof(argv[2]);
  refDatasetNr=atoi(argv[3]);
  scale=atof(argv[4]);
  pre[0]=argv[5];
  pre[1]=argv[6];
  dir=argv[7];





  // create NURBS reference path
  cout<<"Create NURBS reference path for: "<<pre[0]<<", "<<pre[1]<<": ";
  // get num of instaces N
  char c1[10000];
  strcpy(c1, dir);
  strcat(c1, "/");
  strcat(c1, pre[0]);
  strcat(c1, ".body");
  ifstream body(c1);
  string dummy;
  int N;
  body>>dummy>>N;
  body.close();
  // read approximation points
  Vector<Point_nD<double,2> > pts(2*N+degree);
  double x, y;
  for(int k=1; k<=2*N; k++) {
    filename(k, dir, pre, c1);
    ifstream pos(c1);
    pos.seekg(refDatasetNr*6*sizeof(float));
    pos.read(c1, 6*sizeof(float));
    x=*(((float*)c1)+1);
    y=*(((float*)c1)+2);
    pts[k-1]=Point_nD<double,2>(x,y);
    pos.close();
  }
  for(int i=0; i<degree; i++)
    pts[2*N+i]=pts[i];
  NurbsCurve<double,2> curve;
  // approximiz by NURBS
  curve.leastSquaresClosed(pts, degree, int(kPoints*2*N));
  cout<<"DONE"<<endl;
/////////////////////////////
//  for(int i=0; i<pts.size(); i++)
//    cout<<i<<" "<<pts[i].x()<<" "<<pts[i].y()<<endl;
//  for(double u=0; u<1; u+=1.0/1000)
//    cerr<<u<<" "<<Cp(u, curve).x()<<" "<<Cp(u, curve).y()<<endl;
/////////////////////////////

  // main loop for scaling
  vector<Data> dataL, data, data1;
  dataL=readAndScale(1, dir, pre, curve, scale, N);
  data1=dataL;
  for(int k=2; k<=2*N; k++) {
    data=readAndScale(k, dir, pre, curve, scale, N);
    angle(dataL, data);
    write(k-1, dir, pre, dataL);
    dataL=data;
    cout<<"\rScale normals for: "<<pre[0]<<", "<<pre[1]<<": "<<k*100/2/N<<"% done"<<flush;
  }
  angle(dataL, data1);
  write(2*N, dir, pre, dataL);
  cout<<endl;

  return 0;
}
