#! /bin/sh

if test $# -eq 0; then
  echo "Usage: $0 <dir/to/bodyfiles> [<prefix>]"
  echo "  Create links of *.body, *.bodyenv, *.pos and *.minmax files in the current"
  echo "  directory, pointing to the corrospondending files in <dir/to/bodyfiles>."
  echo "  If <prefix> is given, the name of the links are prefixed with '<prefix>.'."
  exit
fi

DIR=$1
if test $# -eq 2; then
  PREFIX="$2."
else
  PREFIX=""
fi

for EXT in body bodyenv pos; do
  if ls -1 $DIR/*.$EXT >& /dev/null; then 
    for F in $DIR/*.$EXT; do
      ln -s $F $PREFIX$(basename $F)
    done
  fi
done

if ls -1 $DIR/*.minmax >& /dev/null; then 
  for F in $DIR/*.minmax; do
    ln -s $F $(basename $F)
  done
fi
