#
#   AMVis - 3D Multibody Visualisation Program.
#   Copyright (C) 2006 Institute of Applied Mechanics,
#                      Technische Universitaet Muenchen
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

unix:DEFINES+=UNIX
unix:LIBS+=-lGLU
win32:DEFINES+=WINDOWS
win32:LIBS+=-lglu32
macx:warning("AMVis is not tested on the macx platform!")

CONFIG+=release
#CONFIG+=debug
# Space seperated
VERSION=2 6 0
TEMPLATE = app
TARGET = amvis
DEPENDPATH += .
INCLUDEPATH += .
INCLUDEPATH += libwave gle-3.1.0 qwt
DEFINES+=OPENGL_10 V1=$$member(VERSION,0) V2=$$member(VERSION,1) V3=$$member(VERSION,2)
QT += opengl svg
MOC_DIR = moc
OBJECTS_DIR = obj
exists($$[QT_INSTALL_PLUGINS]/iconengines/libqsvg.a) {
  LIBS += -L$$[QT_INSTALL_PLUGINS]/iconengines -lqsvg
  DEFINES += STATIC
}
RC_FILE = amvis.rc
RESOURCES = amvis.qrc
# Input
HEADERS += cbody.h \
           crigidbody.h \
           cube.h \
           kos.h \
           cuboid.h \
           torus.h \
           cylinder.h \
           sphere.h \
           invisiblebody.h \
           drawobjectcontainer.h \
           glwidget.h \
           ketsim.h \
           ketsim_fs.h \
           ketsim_rk_hk_bb.h \
           ketsim_rk_hk_nn.h \
           ketsim_ss.h \
           ketsim_vz.h \
           ketsim_zk_ag_fl1.h \
           ketsim_zk_ag_fl2.h \
           ketsim_zk_zl.h \
           ketsim_objobject.h \
           mainwindow.h \
           objobject.h \
           testelasticbody.h \
           arrow.h \
	   coilspring.h \
           path.h \
           deflectionline.h \
           elastic.h \
           elastic1s21rcm.h \
           elastic1s33rcm.h \
           elastic2s13disk.h \
           elastic1sbta.h \
           quad.h \
           area.h \
	   compoundprimitivebody.h \
	   extrusion.h \
	   rotation.h \
           vt_rockerarm.h \
           vt_valveseat.h \
	   vt_valve.h \
	   simplematvec.h \
	   libwave/wave.h \
           gle-3.1.0/extrude.h \
           gle-3.1.0/gle.h \
           gle-3.1.0/intersect.h \
           gle-3.1.0/port.h \
           gle-3.1.0/rot.h \
           gle-3.1.0/segment.h \
           gle-3.1.0/tube_gc.h \
           gle-3.1.0/vvector.h \
           qwt/qwt_double_interval.h \
           qwt/qwt_global.h \
           qwt/qwt_scale_draw.h \
           qwt/qwt_scale_engine.h \
           qwt/qwt_array.h \
           qwt/qwt.h \
           qwt/qwt_arrow_button.h \
           qwt/qwt_symbol.h \
           qwt/qwt_wheel.h \
           qwt/qwt_picker_machine.h \
           qwt/qwt_scale_div.h \
           qwt/qwt_scale_widget.h \
           qwt/qwt_scale_map.h \
           qwt/qwt_thermo.h \
           qwt/qwt_data.h \
           qwt/qwt_dial_needle.h \
           qwt/qwt_dial.h \
           qwt/qwt_slider.h \
           qwt/qwt_plot_dict.h \
           qwt/qwt_text_label.h \
           qwt/qwt_legend_item.h \
           qwt/qwt_plot_grid.h \
           qwt/qwt_polygon.h \
           qwt/qwt_abstract_slider.h \
           qwt/qwt_plot_item.h \
           qwt/qwt_knob.h \
           qwt/qwt_math.h \
           qwt/qwt_plot_layout.h \
           qwt/qwt_painter.h \
           qwt/qwt_layout_metrics.h \
           qwt/qwt_plot.h \
           qwt/qwt_rect.h \
           qwt/qwt_double_rect.h \
           qwt/qwt_text.h \
           qwt/qwt_dyngrid_layout.h \
           qwt/qwt_interval_data.h \
           qwt/qwt_color_map.h \
           qwt/qwt_curve_fitter.h \
           qwt/qwt_text_engine.h \
           qwt/qwt_compass_rose.h \
           qwt/qwt_double_range.h \
           qwt/qwt_plot_curve.h \
           qwt/qwt_analog_clock.h \
           qwt/qwt_plot_panner.h \
           qwt/qwt_plot_picker.h \
           qwt/qwt_plot_zoomer.h \
           qwt/qwt_plot_spectrogram.h \
           qwt/qwt_plot_rasteritem.h \
           qwt/qwt_paint_buffer.h \
           qwt/qwt_plot_magnifier.h \
           qwt/qwt_valuelist.h \
           qwt/qwt_abstract_scale.h \
           qwt/qwt_plot_printfilter.h \
           qwt/qwt_plot_canvas.h \
           qwt/qwt_compass.h \
           qwt/qwt_abstract_scale_draw.h \
           qwt/qwt_plot_marker.h \
           qwt/qwt_round_scale_draw.h \
           qwt/qwt_event_pattern.h \
           qwt/qwt_spline.h \
           qwt/qwt_legend.h \
           qwt/qwt_panner.h \
           qwt/qwt_picker.h \
           qwt/qwt_raster_data.h \
           qwt/qwt_counter.h

SOURCES += cbody.cpp \
           crigidbody.cpp \
           cube.cpp \
           kos.cpp \
           cuboid.cpp \
           torus.cpp \
           cylinder.cpp \
           sphere.cpp \
           invisiblebody.cpp \
           drawobjectcontainer.cpp \
           glwidget.cpp \
           ketsim.cpp \
           ketsim_fs.cpp \
           ketsim_rk_hk_bb.cpp \
           ketsim_rk_hk_nn.cpp \
           ketsim_ss.cpp \
           ketsim_vz.cpp \
           ketsim_zk_ag_fl1.cpp \
           ketsim_zk_ag_fl2.cpp \
           ketsim_zk_zl.cpp \
           ketsim_objobject.cpp \
           main.cpp \
           mainwindow.cpp \
           objobject.cpp \
           testelasticbody.cpp \
           arrow.cpp \
	   coilspring.cpp \
           path.cpp \
           deflectionline.cpp \
           elastic.cpp \
           elastic1s21rcm.cpp \
           elastic1s33rcm.cpp \
           elastic2s13disk.cpp \
           elastic1sbta.cpp \
           quad.cpp \
           area.cpp \
	   compoundprimitivebody.cpp \
	   extrusion.cpp \
	   rotation.cpp \
	   vt_rockerarm.cpp \
           vt_valveseat.cpp \
           vt_valve.cpp \
	   simplematvec.cpp \
	   libwave/drawobj_ogl.c \
	   libwave/initobj_ogl.c \
	   libwave/mem.c \
	   libwave/misc.c \
	   libwave/readmap.c \
	   libwave/readmtl.c \
	   libwave/readobj.c \
	   libwave/normals.c \
	   libwave/qimage2data.cc \
           gle-3.1.0/extrude.c \
           gle-3.1.0/texgen.c \
           gle-3.1.0/ex_raw.c \
           gle-3.1.0/ex_angle.c \
           gle-3.1.0/ex_cut_round.c \
           gle-3.1.0/intersect.c \
           gle-3.1.0/view.c \
           gle-3.1.0/segment.c \
           gle-3.1.0/round_cap.c \
           gle-3.1.0/urotate.c \
           qwt/qwt_abstract_scale.cpp \
           qwt/qwt_compass_rose.cpp \
           qwt/qwt_text.cpp \
           qwt/qwt_plot_panner.cpp \
           qwt/qwt_scale_draw.cpp \
           qwt/qwt_double_rect.cpp \
           qwt/qwt_plot_item.cpp \
           qwt/qwt_round_scale_draw.cpp \
           qwt/qwt_event_pattern.cpp \
           qwt/qwt_math.cpp \
           qwt/qwt_symbol.cpp \
           qwt/qwt_double_interval.cpp \
           qwt/qwt_thermo.cpp \
           qwt/qwt_scale_engine.cpp \
           qwt/qwt_dial_needle.cpp \
           qwt/qwt_plot_rasteritem.cpp \
           qwt/qwt_plot_marker.cpp \
           qwt/qwt_layout_metrics.cpp \
           qwt/qwt_plot_spectrogram.cpp \
           qwt/qwt_paint_buffer.cpp \
           qwt/qwt_text_engine.cpp \
           qwt/qwt_picker.cpp \
           qwt/qwt_spline.cpp \
           qwt/qwt_slider.cpp \
           qwt/qwt_plot_dict.cpp \
           qwt/qwt_counter.cpp \
           qwt/qwt_plot_printfilter.cpp \
           qwt/qwt_picker_machine.cpp \
           qwt/qwt_double_range.cpp \
           qwt/qwt_painter.cpp \
           qwt/qwt_compass.cpp \
           qwt/qwt_plot.cpp \
           qwt/qwt_scale_div.cpp \
           qwt/qwt_rect.cpp \
           qwt/qwt_plot_xml.cpp \
           qwt/qwt_color_map.cpp \
           qwt/qwt_plot_picker.cpp \
           qwt/qwt_plot_grid.cpp \
           qwt/qwt_dyngrid_layout.cpp \
           qwt/qwt_dial.cpp \
           qwt/qwt_legend.cpp \
           qwt/qwt_plot_curve.cpp \
           qwt/qwt_data.cpp \
           qwt/qwt_knob.cpp \
           qwt/qwt_scale_widget.cpp \
           qwt/qwt_scale_map.cpp \
           qwt/qwt_analog_clock.cpp \
           qwt/qwt_wheel.cpp \
           qwt/qwt_legend_item.cpp \
           qwt/qwt_abstract_scale_draw.cpp \
           qwt/qwt_plot_canvas.cpp \
           qwt/qwt_panner.cpp \
           qwt/qwt_arrow_button.cpp \
           qwt/qwt_interval_data.cpp \
           qwt/qwt_plot_magnifier.cpp \
           qwt/qwt_abstract_slider.cpp \
           qwt/qwt_plot_axis.cpp \
           qwt/qwt_text_label.cpp \
           qwt/qwt_plot_zoomer.cpp \
           qwt/qwt_curve_fitter.cpp \
           qwt/qwt_raster_data.cpp \
           qwt/qwt_plot_layout.cpp \
           qwt/qwt_plot_print.cpp \
