/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "area.h" // class's header file

// class constructor
Area::Area(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f %f %f \n" ,&base1[0],&base1[1],&base1[2]);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&limit1);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f %f %f \n" ,&base2[0],&base2[1],&base2[2]);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&limit2);
}

Area::Area(FILE *bodyfile): CRigidBody(bodyfile)
{
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   int result;
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f %f %f \n" ,&base1[0],&base1[1],&base1[2]);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&limit1);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f %f %f \n" ,&base2[0],&base2[1],&base2[2]);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&limit2);
}

Area::~Area()
{
}

void Area::init()
{
   CRigidBody::init();

   GLdouble x1[3], x2[3], x3[3], x4[3];

   x1[0] = 0.0;              x1[1] = 0.0;              x1[2] = 0.0;
   x2[0] = base1[0]*limit1;  x2[1] = base1[1]*limit1;  x2[2] = base1[2]*limit1;
   x3[0] = base2[0]*limit2;  x3[1] = base2[1]*limit2;  x3[2] = base2[2]*limit2;
   x4[0] = x2[0] + x3[0];    x4[1] = x2[1] + x3[1];    x4[2] = x2[2] + x3[2];;
 
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   // Draw Area BEGIN
   glBegin( GL_QUAD_STRIP );
     glVertex3dv(x1);
     glVertex3dv(x2);
     glVertex3dv(x3);
     glVertex3dv(x4);
   glEnd();
   // Draw Area END
   glEndList();
}

void Area::draw_contour()
{}
