/*
   AMVis - 3D Multibody Visualisation Program.
   Copyright (C) 2006 Institute of Applied Mechanics,
   Technische Universitaet Muenchen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef COILSPRING_H
#define COILSPRING_H

#include <QMessageBox>
#include "cbody.h" // inheriting class's header file

class CoilSpring : public CBody
{
  public:
    // class constructor
    CoilSpring(char* body_name, char * pos_file);

    // class destructor
    ~CoilSpring();

    void drawBody();
    void draw();
    void init();
    void draw_pure();
    void update(long dataset_number);
    void return_info_string(QString &info);

    // overloaded virtual-functions; only needed for 'Move Camera With Body'
    //void ret_rot(float *rotation);
    void ret_trans(float *translation);
    void return_max_dimensions(float *min_x, float *max_x, float *min_y, float *max_y, float *min_z, float *max_z);

  protected:	  
    GLfloat fWindungen;			// Windungszahl***
    GLfloat r;				// Stärke***
    GLfloat R;				// Radius der Feder (zur Mittellinie)***
    GLfloat fLaenge;	
    GLfloat P1[3];			// Anfangspunkt der Feder
    GLfloat P2[3];			// Endpunkt der Feder

    static const GLint iCircSegments = 48;		// Teilung des Federquerschnitts
    static const GLint iSprSegments = 350;		// Teilung der Schraublinie

    GLfloat fCircStep;
    GLfloat fSprStep;

    GLfloat theta;			// Steigungswinkel
    GLfloat phi, u, v;			// Laufvariablen
    GLfloat alpha;

    GLfloat x;
    GLfloat y;
    GLfloat z;
    GLfloat fZStep;					// Schritte in z-Richtung
    GLfloat su, cu, sv, cv, sw, cw;			// Hilfsvariablen
    GLfloat d[3];	
    GLfloat c, scale_factor;	
    GLfloat normal[3];

    GLfloat vert[4][3];

};

#endif // COILSPRING_H
