/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "compoundprimitivebody.h" // class's header file
#include "sphere.h"
#include "cube.h"
#include "cuboid.h"
#include "cylinder.h"
#include "torus.h"
#include "objobject.h"
#include "extrusion.h"
#include "rotation.h"
#include "kos.h"
#include "vt_rockerarm.h"
#include "vt_valve.h"
#include "vt_valveseat.h"
#include <QMenu>

using namespace std;

// class constructor
CompoundPrimitiveBody::CompoundPrimitiveBody(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file) {


  strcpy(body_file_name, body_name);
  strcpy(posfile_name, pos_file);

  char *charstringline=new char[charlength];
  char ObjectName[charlength];

  parsenextdataline(datafile);
  GetCharacterLine(charstringline, charlength, datafile);
  do {
    sscanf(charstringline, "%s", ObjectName);
    if(strcmp(ObjectName, "Sphere")==0)
      body.push_back(new Sphere(datafile));
    if(strcmp(ObjectName, "Cube")==0)
      body.push_back(new Cube(datafile));
    if(strcmp(ObjectName, "Cuboid")==0)
      body.push_back(new Cuboid(datafile));
    if(strcmp(ObjectName, "Cylinder")==0)
      body.push_back(new class Cylinder(datafile));
    if(strcmp(ObjectName, "Torus")==0)
      body.push_back(new Torus(datafile));
    if(strcmp(ObjectName, "ObjObject")==0)
      body.push_back(new ObjObject(datafile));
    if(strcmp(ObjectName, "Extrusion")==0)
      body.push_back(new Extrusion(datafile));
    if(strcmp(ObjectName, "Rotation")==0)
      body.push_back(new Rotation(datafile));
    if(strcmp(ObjectName, "Kos")==0)
      body.push_back(new Kos(datafile));
    if(strcmp(ObjectName, "VT_RockerArm")==0)
      body.push_back(new VT_RockerArm(datafile));
    if(strcmp(ObjectName, "VT_Valve")==0)
      body.push_back(new VT_Valve(datafile));
    if(strcmp(ObjectName, "VT_ValveSeat")==0)
      body.push_back(new VT_ValveSeat(datafile));

    connect(body[body.size()-1], SIGNAL(sigUpdateGL()), this, SLOT(emitUpdateGL()));

    parsenextdataline(datafile);
    GetCharacterLine(charstringline, charlength, datafile);
  }
  while(!feof(datafile));
}

CompoundPrimitiveBody::~CompoundPrimitiveBody() {
}

/*void CompoundPrimitiveBody::init() {
  CRigidBody::init();

  vector<CRigidBody*>::iterator i;
  for(i=body.begin(); i!=body.end(); i++)
    (*i)->init();
  if(Displ_List) glDeleteLists(Displ_List, 1);
  Displ_List=glGenLists(1);
  glNewList(Displ_List, GL_COMPILE);
  for(i=body.begin(); i!=body.end(); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef((*i)->position_x_initial,(*i)->position_y_initial,(*i)->position_z_initial);
    (*i)->createInitialRotationMatrix();
    glMultMatrixf((*i)->object_initial_matrix);
    glScalef((*i)->scale_factor,(*i)->scale_factor,(*i)->scale_factor);
    if (dynamic_cast<ObjObject*>(*i))  {
      ObjObject* ip=static_cast<ObjObject*>(*i);
      if((ip)->usetex)
        wfEnable(WF_USE_TEXTURES);
      else
        wfDisable(WF_USE_TEXTURES);
      if((ip)->usemat)
        wfEnable(WF_USE_MATERIALS);
      else
        wfDisable(WF_USE_MATERIALS);
      wfDrawObject((ip)->model);
    }   
    else 
    glCallList((*i)->Displ_List);
    glPopMatrix();

    float minmax[3];
    minmax[0]=(*i)->x_min+(*i)->position_x_initial;
    minmax[1]=(*i)->y_min+(*i)->position_y_initial;
    minmax[2]=(*i)->z_min+(*i)->position_z_initial;
    updateminmax(minmax);
    minmax[0]=(*i)->x_max+(*i)->position_x_initial;
    minmax[1]=(*i)->y_max+(*i)->position_y_initial;
    minmax[2]=(*i)->z_max+(*i)->position_z_initial;
    updateminmax(minmax);
  }
  glEndList();
}*/
void CompoundPrimitiveBody::init() {
  CRigidBody::init();

  vector<CRigidBody*>::iterator i;
  for(i=body.begin(); i!=body.end(); i++)
    (*i)->init();

  for(i=body.begin(); i!=body.end(); i++) {
    float minmax[3];
    minmax[0]=(*i)->x_min+(*i)->position_x_initial;
    minmax[1]=(*i)->y_min+(*i)->position_y_initial;
    minmax[2]=(*i)->z_min+(*i)->position_z_initial;
    updateminmax(minmax);
    minmax[0]=(*i)->x_max+(*i)->position_x_initial;
    minmax[1]=(*i)->y_max+(*i)->position_y_initial;
    minmax[2]=(*i)->z_max+(*i)->position_z_initial;
    updateminmax(minmax);
  }
}

void CompoundPrimitiveBody::draw_pure() {
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glDisable(GL_LIGHTING);
   glEnable(GL_COLOR_MATERIAL);
   glColor3fv(pick_color_value);
   glPushMatrix();
   glTranslated(position_x, position_y, position_z);
   glMultMatrixf(object_rotation_matrix);
   glTranslated(position_x_initial, position_y_initial, position_z_initial);
   glMultMatrixf(object_initial_matrix);
   glScaled(scale_factor, scale_factor, scale_factor);

  // Draw all Subbodies
  vector<CRigidBody*>::iterator i;
  for(i=body.begin(); i!=body.end(); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef((*i)->position_x_initial,(*i)->position_y_initial,(*i)->position_z_initial);
    (*i)->createInitialRotationMatrix();
    glMultMatrixf((*i)->object_initial_matrix);
    glScalef((*i)->scale_factor,(*i)->scale_factor,(*i)->scale_factor);
    if (dynamic_cast<ObjObject*>(*i))  {
      ObjObject* ip=static_cast<ObjObject*>(*i);
      if((ip)->usetex)
        wfEnable(WF_USE_TEXTURES);
      else
        wfDisable(WF_USE_TEXTURES);
      if((ip)->usemat)
        wfEnable(WF_USE_MATERIALS);
      else
        wfDisable(WF_USE_MATERIALS);
      wfDrawObject((ip)->model);
    }   
    else 
    glCallList((*i)->Displ_List);
    glPopMatrix();
  }

   glPopMatrix();
   glEnable(GL_LIGHTING);
   glDisable(GL_COLOR_MATERIAL);
}

void CompoundPrimitiveBody::draw() {
   glLineWidth(1.0);
   glPointSize(2.0);
   glEnable(GL_LINE_SMOOTH);
   glEnable(GL_POINT_SMOOTH);
   if (mode ==0) glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   if (mode ==1) glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   if (mode ==2) glPolygonMode(GL_FRONT_AND_BACK, GL_POINT);

   glDisable(GL_COLOR_MATERIAL);
   glEnable(GL_LIGHTING);
   updateRotationMatrix();
   createInitialRotationMatrix();
   glMatrixMode(GL_MODELVIEW);
   glPushMatrix();
   glPolygonOffset(OFFSETFAC0,OFFSETUNIT0);
   glEnable(GL_POLYGON_OFFSET_FILL);
   glEnable(GL_POLYGON_OFFSET_LINE);
   glEnable(GL_POLYGON_OFFSET_POINT);
   glEnable(GL_BLEND);
   glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

   //global translation and rotation
   glTranslated(position_x, position_y, position_z);
   glMultMatrixf(object_rotation_matrix);

   if (local_cos_flag==true) // for R system
   {
      float abs=fmax(fmax(x_max,y_max),z_max);

      glEnable(GL_COLOR_MATERIAL);
      glDisable(GL_LIGHTING);
      glEnable(GL_LINE_SMOOTH);
      glLineWidth(3.0);
      // X DIR red
      glColor3ub(90, 0, 0);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(abs* 1.5, 0.0, 0.0);
      glEnd();
      // Y DIR green
      glColor3ub(0, 90, 0);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(0.0, abs* 1.5, 0.0);
      glEnd();
      // Z DOR blue
      glColor3ub(0, 0, 90);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(0.0, 0.0, abs* 1.5);
      glEnd();
      glEnable(GL_LIGHTING);
      glDisable(GL_COLOR_MATERIAL);
      glLineWidth(1.0);
   };

   translateColorvalueToRGBA(colorvalue, &color[0], &color[1], &color[2], &color[3]);
   glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, color);
   GLfloat mat_specular[] = {1.0,1.0,1.0, 1.0};
   glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
   glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, &color_shininess);
   float em[4]={0,0,0,0};
   glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, em);

   //initial translation and roation
   glTranslated(position_x_initial, position_y_initial, position_z_initial);
   glMultMatrixf(object_initial_matrix);
   glScaled(scale_factor, scale_factor, scale_factor);

  // Draw all Subbodies
  vector<CRigidBody*>::iterator i;
  for(i=body.begin(); i!=body.end(); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
     if ((*i)->local_cos_flag==true) // for R system
     {
        float abs=fmax(fmax((*i)->x_max,(*i)->y_max),(*i)->z_max);

        glEnable(GL_COLOR_MATERIAL);
        glDisable(GL_LIGHTING);
        glEnable(GL_LINE_SMOOTH);
        glLineWidth(3.0);
        // X DIR red
        glColor3ub(90, 0, 0);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(abs* 1.5, 0.0, 0.0);
        glEnd();
        // Y DIR green
        glColor3ub(0, 90, 0);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(0.0, abs* 1.5, 0.0);
        glEnd();
        // Z DOR blue
        glColor3ub(0, 0, 90);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(0.0, 0.0, abs* 1.5);
        glEnd();
        glEnable(GL_LIGHTING);
        glDisable(GL_COLOR_MATERIAL);
        glLineWidth(1.0);
     };
    glTranslatef((*i)->position_x_initial,(*i)->position_y_initial,(*i)->position_z_initial);
    (*i)->createInitialRotationMatrix();
    glMultMatrixf((*i)->object_initial_matrix);
    glScalef((*i)->scale_factor,(*i)->scale_factor,(*i)->scale_factor);
    if (dynamic_cast<ObjObject*>(*i))  {
      ObjObject* ip=static_cast<ObjObject*>(*i);
      if((ip)->usetex)
        wfEnable(WF_USE_TEXTURES);
      else
        wfDisable(WF_USE_TEXTURES);
      if((ip)->usemat)
        wfEnable(WF_USE_MATERIALS);
      else
        wfDisable(WF_USE_MATERIALS);
      wfDrawObject((ip)->model);
    }   
    else 
      glCallList((*i)->Displ_List);
     if ((*i)->local_cos_flag==true) // for L system
     {
        float abs=fmax(fmax((*i)->x_max,(*i)->y_max),(*i)->z_max);

        glEnable(GL_COLOR_MATERIAL);
        glDisable(GL_LIGHTING);
        glEnable(GL_LINE_SMOOTH);
        glLineWidth(3.0);
        // X DIR red
        glColor3ub(255, 0, 0);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(abs* 1.5, 0.0, 0.0);
        glEnd();
        // Y DIR green
        glColor3ub(0, 255, 0);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(0.0, abs* 1.5, 0.0);
        glEnd();
        // Z DOR blue
        glColor3ub(0, 0, 255);
        glBegin(GL_LINE_STRIP);
        glVertex3f(0.0, 0.0, 0.0);
        glVertex3f(0.0, 0.0, abs* 1.5);
        glEnd();
        glEnable(GL_LIGHTING);
        glDisable(GL_COLOR_MATERIAL);
     };
    glPopMatrix();
  }

   glPolygonOffset(0.0,0.0);
   if (contour_flag==true)
   {
      draw_contour();
   };

   if (selected_flag==true)
   {
      glEnable(GL_COLOR_MATERIAL);
      glDisable(GL_LIGHTING);
      glEnable(GL_LINE_SMOOTH);
      glColor3f(0.0, 1.0, 0.0);
      glLineWidth(4.0);
      glBegin(GL_LINE_STRIP);
      glVertex3f(x_min, y_min, z_min);
      glVertex3f(x_min, y_max, z_min);
      glVertex3f(x_min, y_max, z_max);
      glVertex3f(x_min, y_min, z_max);
      glVertex3f(x_min, y_min, z_min);
      glVertex3f(x_max, y_min, z_min);
      glVertex3f(x_max, y_max, z_min);
      glVertex3f(x_max, y_max, z_max);
      glVertex3f(x_max, y_min, z_max);
      glVertex3f(x_max, y_min, z_min);
      glEnd();
      glBegin(GL_LINES);
      glVertex3f(x_min, y_min, z_min);
      glVertex3f(x_max, y_min, z_min);
      glVertex3f(x_min, y_max, z_min);
      glVertex3f(x_max, y_max, z_min);
      glVertex3f(x_min, y_max, z_max);
      glVertex3f(x_max, y_max, z_max);
      glVertex3f(x_min, y_min, z_max);
      glVertex3f(x_max, y_min, z_max);
      glEnd();
      glEnable(GL_LIGHTING);
      glPolygonOffset(0.0,0.0);
      glEnable(GL_POLYGON_OFFSET_LINE);
      glDisable(GL_COLOR_MATERIAL);
   };


   if (local_cos_flag==true) // for L system
   {
      float abs=fmax(fmax(x_max,y_max),z_max);

      glEnable(GL_COLOR_MATERIAL);
      glDisable(GL_LIGHTING);
      glEnable(GL_LINE_SMOOTH);
      glLineWidth(3.0);
      // X DIR red
      glColor3ub(255, 0, 0);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(abs* 1.5, 0.0, 0.0);
      glEnd();
      // Y DIR green
      glColor3ub(0, 255, 0);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(0.0, abs* 1.5, 0.0);
      glEnd();
      // Z DOR blue
      glColor3ub(0, 0, 255);
      glBegin(GL_LINE_STRIP);
      glVertex3f(0.0, 0.0, 0.0);
      glVertex3f(0.0, 0.0, abs* 1.5);
      glEnd();
      glEnable(GL_LIGHTING);
      glDisable(GL_COLOR_MATERIAL);
   };

   glDisable(GL_POLYGON_OFFSET_FILL);
   glDisable(GL_POLYGON_OFFSET_LINE);
   glDisable(GL_POLYGON_OFFSET_POINT);
   glPolygonOffset(0.0,0.0);
   glPopMatrix();

  if(path_flag) {
    long drawpathto=curdataset;
    if(path.size()<=(unsigned long)drawpathto) {
      for(int i=path.size(); i<=drawpathto; i++) {
        update(i);
        Point3D *p=new Point3D;
        p->x=position_x;
        p->y=position_y;
        p->z=position_z;
        path.push_back(p);
      }
    }
    drawPath(0, 1, 0);
  }
}

void CompoundPrimitiveBody::draw_contour() {
  vector<CRigidBody*>::iterator i;
  for(i=body.begin(); i!=body.end(); i++) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef((*i)->position_x_initial,(*i)->position_y_initial,(*i)->position_z_initial);
    (*i)->createInitialRotationMatrix();
    glMultMatrixf((*i)->object_initial_matrix);
    glScalef((*i)->scale_factor,(*i)->scale_factor,(*i)->scale_factor);
    (*i)->draw_contour();
    glPopMatrix();
  }
}

void CompoundPrimitiveBody::edit() {
  QMenu menu;
  QAction *compAct=menu.addAction(tr("Edit Compound Body"));
  menu.addSeparator();
  QList<QAction*> acts;
  for(unsigned int i=1; i<=body.size(); i++) {
    acts.append(menu.addAction(tr("Edit Subbody %1").arg(i)));
  }
  QAction* act=menu.exec(QCursor::pos());
  if(compAct==act)
    CRigidBody::edit();
  else {
    for(int i=0; i<acts.size(); i++)
      if(acts[i]==act)
        editSubBody(i);
  }
}

void CompoundPrimitiveBody::editSubBody(int i) {
  body[i]->edit();
}
