/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technical University of Munich

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>

#define DIGIT (*t=='0' || *t=='1' || *t=='2' || *t=='3' || *t=='4' || *t=='5' || *t=='6' || *t=='7' || *t=='8' || *t=='9')

int main(int argc, char **argv) {
  if(argc!=2) {
    fprintf(stderr, "Usage: %s <format> < infile > outfile\n", argv[0]);
    fprintf(stderr, "\n");
    fprintf(stderr, "<format> example = ffc5si\n");
    fprintf(stderr, "f: float (4 byte)\n");
    fprintf(stderr, "c: unsigned char (1 byte)\n");
    fprintf(stderr, "i: unsigned short int (2 byte)\n");
    fprintf(stderr, "l: unsigned int (4 byte)\n");
    fprintf(stderr, "?s: string of lenght ? (? byte)\n");
    return 0;
  }
  char type[1024];
  strcpy(type, argv[1]);
  char blank[]="                                                                                 ";

  char *t;
  float f;
  unsigned char c;
  unsigned short int i;
  unsigned int l;
  char s[10240];
  while(!feof(stdin)) {
    for(t=&(type[0]); *t!=0; ++t) {
      if(*t=='f') {
        fscanf(stdin, "%f", &f);
        if(feof(stdin)) break;
        fwrite(&f, sizeof(float), 1, stdout);
      }
      if(*t=='c') {
        fscanf(stdin, "%c", &c);
        if(feof(stdin)) break;
        fwrite(&c, sizeof(unsigned char), 1, stdout);
      }
      if(*t=='i') {
        fscanf(stdin, "%hu", &i);
        if(feof(stdin)) break;
        fwrite(&i, sizeof(unsigned short int), 1, stdout);
      }
      if(*t=='l') {
        fscanf(stdin, "%u", &l);
        if(feof(stdin)) break;
        fwrite(&l, sizeof(unsigned int), 1, stdout);
      }
      if(DIGIT) {
        char *b=t;
        while(DIGIT) ++t;
        char tt=*t;
        *t=0;
        int length;
        sscanf(b, "%d", &length);
        *t=tt;
        if(*t=='s') {
          fscanf(stdin, "%s", s);
          if(feof(stdin)) break;
          fwrite(blank, sizeof(char), length-strlen(s), stdout);
          fwrite(s, sizeof(char), strlen(s), stdout);
        }
      }
    }
    if(feof(stdin)) break;
  }

  return 0;
}
