#! /bin/sh

for a in *; do
  if [ ${a%*.body}.body = $a ]; then
    b=$a
    echo -n "$b:"
    type=$(sed -re "/^[ ]*#/d;/^[ ]*$/d" $b | sed -rne "1s/^[ ]*(.*)[ ]*$/\1/p")
    inst=$(sed -re "/^[ ]*#/d;/^[ ]*$/d" $b | sed -rne "2s/^[ ]*(.*)[ ]*$/\1/p")
    test $inst -le 9999 && inststr=$inst
    test $inst -le 999 && inststr=0$inst
    test $inst -le 99 && inststr=00$inst
    test $inst -le 9 && inststr=000$inst
    bin=$(sed -re "/^[ ]*#/d;/^[ ]*$/d" $b | sed -rne "3s/^[ ]*(.*)[ ]*$/\1/p")
    binline=$(sed -rne "/^[ ]*#/d;/^[ ]*$/d;=" $b | sed -rne "3p")
    if [ $bin -eq 1 ]; then
      echo -n " bin->ascii:"
      convert=${0%*convertdir.sh}./bin2ascii/bin2ascii
      sed -re "${binline}s/^.*$/0/" < $b > $b.new
      rm $b
      mv $b.new $b
    else
      echo -n " ascii->bin:"
      convert=${0%*convertdir.sh}./ascii2bin/ascii2bin
      sed -re "${binline}s/^.*$/1/" < $b > $b.new
      rm $b
      mv $b.new $b
    fi

    i=0
    while [ $i -lt $inst ]; do
      i=$[$i+1]
      test $i -le 9999 && istr=$i
      test $i -le 999 && istr=0$i
      test $i -le 99 && istr=00$i
      test $i -le 9 && istr=000$i
      p=${a%*.body}.$istr.pos
      if [ $type = "KETSIM_VZ" -o \
           $type = "KETSIM_FS" -o \
           $type = "KETSIM_SS" -o \
           $type = "KETSIM_RK_HK_NN" -o \
           $type = "KETSIM_RK_HK_BB" -o \
           $type = "KETSIM_ZK_ZL" -o \
           $type = "KETSIM_ZK_AG_FL1" -o \
           $type = "KETSIM_ZK_AG_FL2" ]; then
         $convert ffffff < $p > $p.new
         rm $p
         mv $p.new $p
      elif [ $type = "Cube" -o \
             $type = "Cuboid" -o \
             $type = "Sphere" -o \
             $type = "Cylinder" -o \
             $type = "Torus" -o \
             $type = "ObjObject" -o \
             $type = "Arrow" -o \
             $type = "InvisibleObject" ]; then
         $convert ffffffff < $p > $p.new
         rm $p
         mv $p.new $p
      elif [ $type = "Path" ]; then
         $convert ffff < $p > $p.new
         rm $p
         mv $p.new $p
      else
         echo -n " Unknown object type \"$type\""
         break
      fi
      echo -en " Pos-file # $istr/${inststr}\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
    done
    echo ""
  fi
done
