/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef CRIGIDBODY_H
#define CRIGIDBODY_H

#include "GL/glu.h"
#include "GL/gl.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <QMessageBox>
#include <vector>

#include "cbody.h" // inheriting class's header file

class QDoubleSpinBox;
class QDialog;
class QwtSlider;
class QwtKnob;
class QwtWheel;
class QRadioButton;

// No description
class CRigidBody : public CBody
{
Q_OBJECT

public:
   // class constructor
   CRigidBody(char* body_name, char * pos_file);
   CRigidBody(FILE *bodyfile);
   // class destructor
   ~CRigidBody();
   // No description
   virtual void draw();
   virtual void read_data();
   GLuint  Displ_List;
   float angle_alpha;
   // angle beta for the rotation of an object
   float angle_beta;
   // angle gamma for the rotation of an object
   float angle_gamma;
   //the object's positions
   float position_x;
   float position_y;
   float position_z;
   float position_x_initial;
   float position_y_initial;
   float position_z_initial;
   float current_time;
   // initial angles
   float angle_alpha_initial;
   float angle_beta_initial;
   float angle_gamma_initial;
   float x_min, x_max;
   float y_min, y_max;
   float z_min, z_max;
   float scale_factor;
   bool draw_color;

   // Kardan angle transformation matrix
   GLfloat object_rotation_matrix[16];
   GLfloat object_initial_matrix[16];
   GLfloat color[4];
   float   colorvalue;
   GLfloat	color_shininess;
   virtual void updateminmax(float vector[3]);
   virtual void updateminmax(double vector[3]);
   virtual void updateRotationMatrix();
   virtual void createInitialRotationMatrix();
   virtual void update(long dataset_number);
   virtual long get_dataset();
   virtual long get_dataset_last();
   long recordsize;
   bool posfile_ready;
   virtual long getrecordsizetext(FILE * textfilepointer);
   virtual bool getFilePointerandRecSize();
   virtual long getlastposition(FILE * filestream);
   virtual void init();
   GLUtesselator *tobj;
   virtual void ret_time(float* time) ;
   // No description
   virtual void draw_contour() = 0;
   // No description
   virtual void ret_rot(float* rotation) ;
   virtual void ret_trans(float* translation);
   // No description
   virtual void return_max_dimensions(float* min_x, float* max_x, float* min_y, float* max_y,float* min_z, float* max_z);
   virtual void draw_pure();
   void return_info_string(QString &info);
   // No description

   void edit();
protected:

  bool isSubBody;
  QDoubleSpinBox *trans[3];
  QDoubleSpinBox *rot[3];
  QDialog *editDialog;
  GLfloat Am[16];
  GLfloat transm[3];
  QwtKnob *rotK[3];
  QwtKnob *rotLK[3], *rotRK[3], *rotWK[3];
  QwtWheel *transLW[3], *transRW[3], *transWW[3];
  QRadioButton *rotPointL, *rotPointR, *rotPointW;
  void sliderTMoved(double v, int nr);
  void sliderRMoved(double v, int nr);

protected slots:
  void updateEdit();
  void sliderTPressed();
  void sliderTReleased();
  void sliderTL0Moved(double v);
  void sliderTL1Moved(double v);
  void sliderTL2Moved(double v);
  void sliderTW0Moved(double v);
  void sliderTW1Moved(double v);
  void sliderTW2Moved(double v);
  void sliderRPressed();
  void sliderRReleased();
  void sliderRL0Moved(double v);
  void sliderRL1Moved(double v);
  void sliderRL2Moved(double v);
  void sliderRR0Moved(double v);
  void sliderRR1Moved(double v);
  void sliderRR2Moved(double v);
  void sliderRW0Moved(double v);
  void sliderRW1Moved(double v);
  void sliderRW2Moved(double v);
  void showCos(int state);

private:
  void writeToConsole();
};

#endif // CRIGIDBODY_H
