/*
    AMVis - 3D Multibody Visualisation Program.
    Copyright (C) 2006 Institute of Applied Mechanics,
                       Technische Universitaet Muenchen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <GL/gl.h>
#include "cube.h" // class's header file

// class constructor
Cube::Cube(char* body_name, char * pos_file): CRigidBody( body_name,  pos_file)
{
   strcpy(body_file_name,body_name);
   strcpy(posfile_name , pos_file);
   int result;
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   result = GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&CubeSize);
}

Cube::Cube(FILE *bodyfile): CRigidBody(bodyfile)
{
   char* charstringline = new char [charlength];
   parsenextdataline(datafile);
   GetCharacterLine(charstringline, charlength, datafile);
   sscanf(charstringline, "%f \n" ,&CubeSize);
}

Cube::~Cube()
{
}

void Cube::init()
{
   CRigidBody::init();
   float minmax[3];
   minmax[0] = CubeSize / 2.0;
   minmax[1] = CubeSize / 2.0;
   minmax[2] = CubeSize / 2.0;
   updateminmax(minmax) ;
   minmax[0] = -CubeSize / 2.0;
   minmax[1] = -CubeSize / 2.0;
   minmax[2] = -CubeSize / 2.0;
   updateminmax(minmax) ;
   if (Displ_List) glDeleteLists(Displ_List, 1);
   Displ_List = glGenLists(1);
   glNewList(Displ_List, GL_COMPILE);
   // Draw Cube BEGIN
   static const GLfloat n[6][3] = {
      {-1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {1.0, 0.0, 0.0},
      {0.0, -1.0, 0.0},
      {0.0, 0.0, 1.0},
      {0.0, 0.0, -1.0}
   };
   static const GLint faces[6][4] = {
      {0, 1, 2, 3},
      {3, 2, 6, 7},
      {7, 6, 5, 4},
      {4, 5, 1, 0},
      {5, 6, 2, 1},
      {7, 4, 0, 3}
   };
   GLfloat v[8][3];
   GLint i;
   v[0][0] = v[1][0] = v[2][0] = v[3][0] = -CubeSize / 2;
   v[4][0] = v[5][0] = v[6][0] = v[7][0] = CubeSize / 2;
   v[0][1] = v[1][1] = v[4][1] = v[5][1] = -CubeSize / 2;
   v[2][1] = v[3][1] = v[6][1] = v[7][1] = CubeSize / 2;
   v[0][2] = v[3][2] = v[4][2] = v[7][2] = -CubeSize / 2;
   v[1][2] = v[2][2] = v[5][2] = v[6][2] = CubeSize / 2;
   for (i = 5; i >= 0; i--) {
      glBegin(GL_QUADS);
      glNormal3fv(&n[i][0]);
      glVertex3fv(&v[faces[i][0]][0]);
      glVertex3fv(&v[faces[i][1]][0]);
      glVertex3fv(&v[faces[i][2]][0]);
      glVertex3fv(&v[faces[i][3]][0]);
      glEnd();
   }
   // Draw Cube END
   glEndList();

}

void Cube::draw_contour()
{
   glEnable(GL_POLYGON_OFFSET_LINE);
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEnable(GL_COLOR_MATERIAL);
   glLineWidth(1.0);
   glPolygonOffset(OFFSETFAC1,OFFSETUNIT1);
   glDisable(GL_LIGHTING);
   glEnable(GL_LINE_SMOOTH);
   glColor3f(0.0, 0.0, 0.0);
   glCallList(Displ_List);
   glPolygonOffset(0.0,0.0);
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glDisable(GL_POLYGON_OFFSET_LINE);
}
